<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCCAProfiles StructType
 * @subpackage Structs
 */
class LCCAProfiles extends AbstractStructBase
{
    /**
     * The ccaId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ccaId;
    /**
     * The primarySoftSwitchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primarySoftSwitchId;
    /**
     * The secondarySoftSwitchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondarySoftSwitchId;
    /**
     * The objectClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $objectClass;
    /**
     * The subscriberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberType;
    /**
     * The sipAliasSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipAliasSuffix;
    /**
     * The sipUserNameSuffix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipUserNameSuffix;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCCAProfiles
     * @uses LCCAProfiles::setCcaId()
     * @uses LCCAProfiles::setPrimarySoftSwitchId()
     * @uses LCCAProfiles::setSecondarySoftSwitchId()
     * @uses LCCAProfiles::setObjectClass()
     * @uses LCCAProfiles::setSubscriberType()
     * @uses LCCAProfiles::setSipAliasSuffix()
     * @uses LCCAProfiles::setSipUserNameSuffix()
     * @uses LCCAProfiles::setUuid()
     * @param string $ccaId
     * @param string $primarySoftSwitchId
     * @param string $secondarySoftSwitchId
     * @param string $objectClass
     * @param string $subscriberType
     * @param string $sipAliasSuffix
     * @param string $sipUserNameSuffix
     * @param string $uuid
     */
    public function __construct($ccaId = null, $primarySoftSwitchId = null, $secondarySoftSwitchId = null, $objectClass = null, $subscriberType = null, $sipAliasSuffix = null, $sipUserNameSuffix = null, $uuid = null)
    {
        $this
            ->setCcaId($ccaId)
            ->setPrimarySoftSwitchId($primarySoftSwitchId)
            ->setSecondarySoftSwitchId($secondarySoftSwitchId)
            ->setObjectClass($objectClass)
            ->setSubscriberType($subscriberType)
            ->setSipAliasSuffix($sipAliasSuffix)
            ->setSipUserNameSuffix($sipUserNameSuffix)
            ->setUuid($uuid);
    }
    /**
     * Get ccaId value
     * @return string|null
     */
    public function getCcaId()
    {
        return $this->ccaId;
    }
    /**
     * Set ccaId value
     * @param string $ccaId
     * @return LCCAProfiles
     */
    public function setCcaId($ccaId = null)
    {
        // validation for constraint: string
        if (!is_null($ccaId) && !is_string($ccaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ccaId)), __LINE__);
        }
        $this->ccaId = $ccaId;
        return $this;
    }
    /**
     * Get primarySoftSwitchId value
     * @return string|null
     */
    public function getPrimarySoftSwitchId()
    {
        return $this->primarySoftSwitchId;
    }
    /**
     * Set primarySoftSwitchId value
     * @param string $primarySoftSwitchId
     * @return LCCAProfiles
     */
    public function setPrimarySoftSwitchId($primarySoftSwitchId = null)
    {
        // validation for constraint: string
        if (!is_null($primarySoftSwitchId) && !is_string($primarySoftSwitchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primarySoftSwitchId)), __LINE__);
        }
        $this->primarySoftSwitchId = $primarySoftSwitchId;
        return $this;
    }
    /**
     * Get secondarySoftSwitchId value
     * @return string|null
     */
    public function getSecondarySoftSwitchId()
    {
        return $this->secondarySoftSwitchId;
    }
    /**
     * Set secondarySoftSwitchId value
     * @param string $secondarySoftSwitchId
     * @return LCCAProfiles
     */
    public function setSecondarySoftSwitchId($secondarySoftSwitchId = null)
    {
        // validation for constraint: string
        if (!is_null($secondarySoftSwitchId) && !is_string($secondarySoftSwitchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondarySoftSwitchId)), __LINE__);
        }
        $this->secondarySoftSwitchId = $secondarySoftSwitchId;
        return $this;
    }
    /**
     * Get objectClass value
     * @return string|null
     */
    public function getObjectClass()
    {
        return $this->objectClass;
    }
    /**
     * Set objectClass value
     * @param string $objectClass
     * @return LCCAProfiles
     */
    public function setObjectClass($objectClass = null)
    {
        // validation for constraint: string
        if (!is_null($objectClass) && !is_string($objectClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectClass)), __LINE__);
        }
        $this->objectClass = $objectClass;
        return $this;
    }
    /**
     * Get subscriberType value
     * @return string|null
     */
    public function getSubscriberType()
    {
        return $this->subscriberType;
    }
    /**
     * Set subscriberType value
     * @param string $subscriberType
     * @return LCCAProfiles
     */
    public function setSubscriberType($subscriberType = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberType) && !is_string($subscriberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberType)), __LINE__);
        }
        $this->subscriberType = $subscriberType;
        return $this;
    }
    /**
     * Get sipAliasSuffix value
     * @return string|null
     */
    public function getSipAliasSuffix()
    {
        return $this->sipAliasSuffix;
    }
    /**
     * Set sipAliasSuffix value
     * @param string $sipAliasSuffix
     * @return LCCAProfiles
     */
    public function setSipAliasSuffix($sipAliasSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sipAliasSuffix) && !is_string($sipAliasSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sipAliasSuffix)), __LINE__);
        }
        $this->sipAliasSuffix = $sipAliasSuffix;
        return $this;
    }
    /**
     * Get sipUserNameSuffix value
     * @return string|null
     */
    public function getSipUserNameSuffix()
    {
        return $this->sipUserNameSuffix;
    }
    /**
     * Set sipUserNameSuffix value
     * @param string $sipUserNameSuffix
     * @return LCCAProfiles
     */
    public function setSipUserNameSuffix($sipUserNameSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($sipUserNameSuffix) && !is_string($sipUserNameSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sipUserNameSuffix)), __LINE__);
        }
        $this->sipUserNameSuffix = $sipUserNameSuffix;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LCCAProfiles
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LCCAProfiles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
