<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LAssignedPresenceServers StructType
 * @subpackage Structs
 */
class LAssignedPresenceServers extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The nodeUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nodeUsage;
    /**
     * The numUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numUsers;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LAssignedPresenceServers
     * @uses LAssignedPresenceServers::setName()
     * @uses LAssignedPresenceServers::setDescription()
     * @uses LAssignedPresenceServers::setNodeUsage()
     * @uses LAssignedPresenceServers::setNumUsers()
     * @uses LAssignedPresenceServers::setUuid()
     * @param string $name
     * @param string $description
     * @param string $nodeUsage
     * @param string $numUsers
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $nodeUsage = null, $numUsers = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setNodeUsage($nodeUsage)
            ->setNumUsers($numUsers)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LAssignedPresenceServers
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LAssignedPresenceServers
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get nodeUsage value
     * @return string|null
     */
    public function getNodeUsage()
    {
        return $this->nodeUsage;
    }
    /**
     * Set nodeUsage value
     * @uses XNodeUsage::valueIsValid()
     * @uses XNodeUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nodeUsage
     * @return LAssignedPresenceServers
     */
    public function setNodeUsage($nodeUsage = null)
    {
        // validation for constraint: enumeration
        if (!XNodeUsage::valueIsValid($nodeUsage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nodeUsage, implode(', ', XNodeUsage::getValidValues())), __LINE__);
        }
        $this->nodeUsage = $nodeUsage;
        return $this;
    }
    /**
     * Get numUsers value
     * @return string|null
     */
    public function getNumUsers()
    {
        return $this->numUsers;
    }
    /**
     * Set numUsers value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numUsers
     * @return LAssignedPresenceServers
     */
    public function setNumUsers($numUsers = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($numUsers)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numUsers, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->numUsers = $numUsers;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LAssignedPresenceServers
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LAssignedPresenceServers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
