<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSipProfileOptionsReq StructType
 * @subpackage Structs
 */
class GetSipProfileOptionsReq extends AbstractStructBase
{
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedChoices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var OXSipProfile
     */
    public $returnedChoices;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetSipProfileOptionsReq
     * @uses GetSipProfileOptionsReq::setUuid()
     * @uses GetSipProfileOptionsReq::setReturnedChoices()
     * @uses GetSipProfileOptionsReq::setSequence()
     * @param string $uuid
     * @param OXSipProfile $returnedChoices
     * @param int $sequence
     */
    public function __construct($uuid = null, OXSipProfile $returnedChoices = null, $sequence = null)
    {
        $this
            ->setUuid($uuid)
            ->setReturnedChoices($returnedChoices)
            ->setSequence($sequence);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return GetSipProfileOptionsReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get returnedChoices value
     * @return OXSipProfile|null
     */
    public function getReturnedChoices()
    {
        return $this->returnedChoices;
    }
    /**
     * Set returnedChoices value
     * @param OXSipProfile $returnedChoices
     * @return GetSipProfileOptionsReq
     */
    public function setReturnedChoices(OXSipProfile $returnedChoices = null)
    {
        $this->returnedChoices = $returnedChoices;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return GetSipProfileOptionsReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetSipProfileOptionsReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
