<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetApplicationUserCapfProfileReq StructType
 * @subpackage Structs
 */
class GetApplicationUserCapfProfileReq extends AbstractStructBase
{
    /**
     * The instanceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $instanceId;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var RApplicationUserCapfProfile
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetApplicationUserCapfProfileReq
     * @uses GetApplicationUserCapfProfileReq::setInstanceId()
     * @uses GetApplicationUserCapfProfileReq::setUuid()
     * @uses GetApplicationUserCapfProfileReq::setReturnedTags()
     * @uses GetApplicationUserCapfProfileReq::setSequence()
     * @param string $instanceId
     * @param string $uuid
     * @param RApplicationUserCapfProfile $returnedTags
     * @param int $sequence
     */
    public function __construct($instanceId = null, $uuid = null, RApplicationUserCapfProfile $returnedTags = null, $sequence = null)
    {
        $this
            ->setInstanceId($instanceId)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get instanceId value
     * @return string
     */
    public function getInstanceId()
    {
        return $this->instanceId;
    }
    /**
     * Set instanceId value
     * @param string $instanceId
     * @return GetApplicationUserCapfProfileReq
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instanceId)), __LINE__);
        }
        $this->instanceId = $instanceId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return GetApplicationUserCapfProfileReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return RApplicationUserCapfProfile|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param RApplicationUserCapfProfile $returnedTags
     * @return GetApplicationUserCapfProfileReq
     */
    public function setReturnedTags(RApplicationUserCapfProfile $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return GetApplicationUserCapfProfileReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetApplicationUserCapfProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
