<?php
/**
 * This class stands for XZzconfBridge EnumType
 * @subpackage Enumerations
 */
class XZzconfBridge
{
    /**
     * Constant for value 'Local'
     * @return string 'Local'
     */
    const VALUE_LOCAL = 'Local';
    /**
     * Constant for value 'CallManger'
     * @return string 'CallManger'
     */
    const VALUE_CALL_MANGER = 'CallManger';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOCAL
     * @uses self::VALUE_CALL_MANGER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOCAL,
            self::VALUE_CALL_MANGER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
