<?php
/**
 * This class stands for XZeroSuppression EnumType
 * @subpackage Enumerations
 */
class XZeroSuppression
{
    /**
     * Constant for value 'B8ZS'
     * @return string 'B8ZS'
     */
    const VALUE_B_8_ZS = 'B8ZS';
    /**
     * Constant for value 'AMI'
     * @return string 'AMI'
     */
    const VALUE_AMI = 'AMI';
    /**
     * Constant for value 'HDB3'
     * @return string 'HDB3'
     */
    const VALUE_HDB_3 = 'HDB3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_B_8_ZS
     * @uses self::VALUE_AMI
     * @uses self::VALUE_HDB_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_B_8_ZS,
            self::VALUE_AMI,
            self::VALUE_HDB_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
