<?php
/**
 * This class stands for XWebPageDisplay EnumType
 * @subpackage Enumerations
 */
class XWebPageDisplay
{
    /**
     * Constant for value 'Expanded'
     * @return string 'Expanded'
     */
    const VALUE_EXPANDED = 'Expanded';
    /**
     * Constant for value 'Collapsed'
     * @return string 'Collapsed'
     */
    const VALUE_COLLAPSED = 'Collapsed';
    /**
     * Constant for value 'Hidden'
     * @return string 'Hidden'
     */
    const VALUE_HIDDEN = 'Hidden';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXPANDED
     * @uses self::VALUE_COLLAPSED
     * @uses self::VALUE_HIDDEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXPANDED,
            self::VALUE_COLLAPSED,
            self::VALUE_HIDDEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
