<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XUserGroup StructType
 * @subpackage Structs
 */
class XUserGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The userRoles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UserRoles
     */
    public $userRoles;
    /**
     * Constructor method for XUserGroup
     * @uses XUserGroup::setName()
     * @uses XUserGroup::setMembers()
     * @uses XUserGroup::setUserRoles()
     * @param string $name
     * @param Members $members
     * @param UserRoles $userRoles
     */
    public function __construct($name = null, Members $members = null, UserRoles $userRoles = null)
    {
        $this
            ->setName($name)
            ->setMembers($members)
            ->setUserRoles($userRoles);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XUserGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return XUserGroup
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get userRoles value
     * @return UserRoles|null
     */
    public function getUserRoles()
    {
        return $this->userRoles;
    }
    /**
     * Set userRoles value
     * @param UserRoles $userRoles
     * @return XUserGroup
     */
    public function setUserRoles(UserRoles $userRoles = null)
    {
        $this->userRoles = $userRoles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XUserGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
