<?php
/**
 * This class stands for XTraceLevelGrouping EnumType
 * @subpackage Enumerations
 */
class XTraceLevelGrouping
{
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'Special'
     * @return string 'Special'
     */
    const VALUE_SPECIAL = 'Special';
    /**
     * Constant for value 'State Transistion'
     * @return string 'State Transistion'
     */
    const VALUE_STATE_TRANSISTION = 'State Transistion';
    /**
     * Constant for value 'Significant'
     * @return string 'Significant'
     */
    const VALUE_SIGNIFICANT = 'Significant';
    /**
     * Constant for value 'Entry_exit'
     * @return string 'Entry_exit'
     */
    const VALUE_ENTRY_EXIT = 'Entry_exit';
    /**
     * Constant for value 'Arbitrary'
     * @return string 'Arbitrary'
     */
    const VALUE_ARBITRARY = 'Arbitrary';
    /**
     * Constant for value 'Detailed'
     * @return string 'Detailed'
     */
    const VALUE_DETAILED = 'Detailed';
    /**
     * Constant for value 'Fatal'
     * @return string 'Fatal'
     */
    const VALUE_FATAL = 'Fatal';
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'Informational'
     * @return string 'Informational'
     */
    const VALUE_INFORMATIONAL = 'Informational';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_SPECIAL
     * @uses self::VALUE_STATE_TRANSISTION
     * @uses self::VALUE_SIGNIFICANT
     * @uses self::VALUE_ENTRY_EXIT
     * @uses self::VALUE_ARBITRARY
     * @uses self::VALUE_DETAILED
     * @uses self::VALUE_FATAL
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_INFORMATIONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ERROR,
            self::VALUE_SPECIAL,
            self::VALUE_STATE_TRANSISTION,
            self::VALUE_SIGNIFICANT,
            self::VALUE_ENTRY_EXIT,
            self::VALUE_ARBITRARY,
            self::VALUE_DETAILED,
            self::VALUE_FATAL,
            self::VALUE_WARNING,
            self::VALUE_INFORMATIONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
