<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XT1Port StructType
 * @subpackage Structs
 */
class XT1Port extends AbstractStructBase
{
    /**
     * The portNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $portNumber;
    /**
     * The callerIdEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callerIdEnable;
    /**
     * The callingPartySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callingPartySelection;
    /**
     * The digitSending
     * Meta informations extracted from the WSDL
     * - default: DTMF
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $digitSending;
    /**
     * The expectedDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $expectedDigits;
    /**
     * The sigDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var SigDigits
     */
    public $sigDigits;
    /**
     * The prefixDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $prefixDn;
    /**
     * The presentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $presentationBit;
    /**
     * The silenceSuppressionThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $silenceSuppressionThreshold;
    /**
     * The startDialProtocol
     * Meta informations extracted from the WSDL
     * - default: Not Set
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $startDialProtocol;
    /**
     * The trunk
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trunk;
    /**
     * The trunkDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trunkDirection;
    /**
     * The trunkLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trunkLevel;
    /**
     * The trunkPadRx
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trunkPadRx;
    /**
     * The trunkPadTx
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trunkPadTx;
    /**
     * The callerId
     * Meta informations extracted from the WSDL
     * - default: ANI
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callerId;
    /**
     * The attendantDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $attendantDn;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $callerIdDn;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - documentation: Arbitrary XML defined by 3rd party vendors.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The endpointId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $endpointId;
    /**
     * The timer1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer1;
    /**
     * The timer2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer2;
    /**
     * The timer3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer3;
    /**
     * The timer4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer4;
    /**
     * The timer5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer5;
    /**
     * The timer6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timer6;
    /**
     * Constructor method for XT1Port
     * @uses XT1Port::setPortNumber()
     * @uses XT1Port::setCallerIdEnable()
     * @uses XT1Port::setCallingPartySelection()
     * @uses XT1Port::setDigitSending()
     * @uses XT1Port::setExpectedDigits()
     * @uses XT1Port::setSigDigits()
     * @uses XT1Port::setPrefixDn()
     * @uses XT1Port::setPresentationBit()
     * @uses XT1Port::setSilenceSuppressionThreshold()
     * @uses XT1Port::setStartDialProtocol()
     * @uses XT1Port::setTrunk()
     * @uses XT1Port::setTrunkDirection()
     * @uses XT1Port::setTrunkLevel()
     * @uses XT1Port::setTrunkPadRx()
     * @uses XT1Port::setTrunkPadTx()
     * @uses XT1Port::setCallerId()
     * @uses XT1Port::setAttendantDn()
     * @uses XT1Port::setUnattendedPort()
     * @uses XT1Port::setCallerIdDn()
     * @uses XT1Port::setVendorConfig()
     * @uses XT1Port::setEndpointId()
     * @uses XT1Port::setTimer1()
     * @uses XT1Port::setTimer2()
     * @uses XT1Port::setTimer3()
     * @uses XT1Port::setTimer4()
     * @uses XT1Port::setTimer5()
     * @uses XT1Port::setTimer6()
     * @param string $portNumber
     * @param string $callerIdEnable
     * @param string $callingPartySelection
     * @param string $digitSending
     * @param string $expectedDigits
     * @param SigDigits $sigDigits
     * @param string $prefixDn
     * @param string $presentationBit
     * @param string $silenceSuppressionThreshold
     * @param string $startDialProtocol
     * @param string $trunk
     * @param string $trunkDirection
     * @param string $trunkLevel
     * @param string $trunkPadRx
     * @param string $trunkPadTx
     * @param string $callerId
     * @param string $attendantDn
     * @param string $unattendedPort
     * @param string $callerIdDn
     * @param XVendorConfig $vendorConfig
     * @param string $endpointId
     * @param string $timer1
     * @param string $timer2
     * @param string $timer3
     * @param string $timer4
     * @param string $timer5
     * @param string $timer6
     */
    public function __construct($portNumber = null, $callerIdEnable = null, $callingPartySelection = null, $digitSending = 'DTMF', $expectedDigits = null, SigDigits $sigDigits = null, $prefixDn = null, $presentationBit = null, $silenceSuppressionThreshold = null, $startDialProtocol = 'Not Set', $trunk = null, $trunkDirection = null, $trunkLevel = null, $trunkPadRx = null, $trunkPadTx = null, $callerId = 'ANI', $attendantDn = null, $unattendedPort = null, $callerIdDn = null, XVendorConfig $vendorConfig = null, $endpointId = null, $timer1 = null, $timer2 = null, $timer3 = null, $timer4 = null, $timer5 = null, $timer6 = null)
    {
        $this
            ->setPortNumber($portNumber)
            ->setCallerIdEnable($callerIdEnable)
            ->setCallingPartySelection($callingPartySelection)
            ->setDigitSending($digitSending)
            ->setExpectedDigits($expectedDigits)
            ->setSigDigits($sigDigits)
            ->setPrefixDn($prefixDn)
            ->setPresentationBit($presentationBit)
            ->setSilenceSuppressionThreshold($silenceSuppressionThreshold)
            ->setStartDialProtocol($startDialProtocol)
            ->setTrunk($trunk)
            ->setTrunkDirection($trunkDirection)
            ->setTrunkLevel($trunkLevel)
            ->setTrunkPadRx($trunkPadRx)
            ->setTrunkPadTx($trunkPadTx)
            ->setCallerId($callerId)
            ->setAttendantDn($attendantDn)
            ->setUnattendedPort($unattendedPort)
            ->setCallerIdDn($callerIdDn)
            ->setVendorConfig($vendorConfig)
            ->setEndpointId($endpointId)
            ->setTimer1($timer1)
            ->setTimer2($timer2)
            ->setTimer3($timer3)
            ->setTimer4($timer4)
            ->setTimer5($timer5)
            ->setTimer6($timer6);
    }
    /**
     * Get portNumber value
     * @return string
     */
    public function getPortNumber()
    {
        return $this->portNumber;
    }
    /**
     * Set portNumber value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $portNumber
     * @return XT1Port
     */
    public function setPortNumber($portNumber = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($portNumber)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $portNumber, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->portNumber = $portNumber;
        return $this;
    }
    /**
     * Get callerIdEnable value
     * @return string
     */
    public function getCallerIdEnable()
    {
        return $this->callerIdEnable;
    }
    /**
     * Set callerIdEnable value
     * @param string $callerIdEnable
     * @return XT1Port
     */
    public function setCallerIdEnable($callerIdEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callerIdEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callerIdEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($callerIdEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdEnable) && !is_string($callerIdEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdEnable)), __LINE__);
        }
        $this->callerIdEnable = $callerIdEnable;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses XCallingPartySelection::valueIsValid()
     * @uses XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return XT1Port
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySelection, implode(', ', XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get digitSending value
     * @return string
     */
    public function getDigitSending()
    {
        return $this->digitSending;
    }
    /**
     * Set digitSending value
     * @uses XDigitSending::valueIsValid()
     * @uses XDigitSending::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitSending
     * @return XT1Port
     */
    public function setDigitSending($digitSending = 'DTMF')
    {
        // validation for constraint: enumeration
        if (!XDigitSending::valueIsValid($digitSending)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $digitSending, implode(', ', XDigitSending::getValidValues())), __LINE__);
        }
        $this->digitSending = $digitSending;
        return $this;
    }
    /**
     * Get expectedDigits value
     * @return string
     */
    public function getExpectedDigits()
    {
        return $this->expectedDigits;
    }
    /**
     * Set expectedDigits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expectedDigits
     * @return XT1Port
     */
    public function setExpectedDigits($expectedDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($expectedDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $expectedDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->expectedDigits = $expectedDigits;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return SigDigits
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param SigDigits $sigDigits
     * @return XT1Port
     */
    public function setSigDigits(SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get prefixDn value
     * @return string
     */
    public function getPrefixDn()
    {
        return $this->prefixDn;
    }
    /**
     * Set prefixDn value
     * @param string $prefixDn
     * @return XT1Port
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDn) && strlen($prefixDn) > 255) || (is_array($prefixDn) && count($prefixDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($prefixDn) ? strlen($prefixDn) : count($prefixDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDn)), __LINE__);
        }
        $this->prefixDn = $prefixDn;
        return $this;
    }
    /**
     * Get presentationBit value
     * @return string
     */
    public function getPresentationBit()
    {
        return $this->presentationBit;
    }
    /**
     * Set presentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $presentationBit
     * @return XT1Port
     */
    public function setPresentationBit($presentationBit = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($presentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $presentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->presentationBit = $presentationBit;
        return $this;
    }
    /**
     * Get silenceSuppressionThreshold value
     * @return string
     */
    public function getSilenceSuppressionThreshold()
    {
        return $this->silenceSuppressionThreshold;
    }
    /**
     * Set silenceSuppressionThreshold value
     * @uses XSilenceSuppressionThreshold::valueIsValid()
     * @uses XSilenceSuppressionThreshold::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $silenceSuppressionThreshold
     * @return XT1Port
     */
    public function setSilenceSuppressionThreshold($silenceSuppressionThreshold = null)
    {
        // validation for constraint: enumeration
        if (!XSilenceSuppressionThreshold::valueIsValid($silenceSuppressionThreshold)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $silenceSuppressionThreshold, implode(', ', XSilenceSuppressionThreshold::getValidValues())), __LINE__);
        }
        $this->silenceSuppressionThreshold = $silenceSuppressionThreshold;
        return $this;
    }
    /**
     * Get startDialProtocol value
     * @return string
     */
    public function getStartDialProtocol()
    {
        return $this->startDialProtocol;
    }
    /**
     * Set startDialProtocol value
     * @uses XStartDialProtocol::valueIsValid()
     * @uses XStartDialProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDialProtocol
     * @return XT1Port
     */
    public function setStartDialProtocol($startDialProtocol = 'Not Set')
    {
        // validation for constraint: enumeration
        if (!XStartDialProtocol::valueIsValid($startDialProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startDialProtocol, implode(', ', XStartDialProtocol::getValidValues())), __LINE__);
        }
        $this->startDialProtocol = $startDialProtocol;
        return $this;
    }
    /**
     * Get trunk value
     * @return string
     */
    public function getTrunk()
    {
        return $this->trunk;
    }
    /**
     * Set trunk value
     * @uses XTrunk::valueIsValid()
     * @uses XTrunk::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunk
     * @return XT1Port
     */
    public function setTrunk($trunk = null)
    {
        // validation for constraint: enumeration
        if (!XTrunk::valueIsValid($trunk)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunk, implode(', ', XTrunk::getValidValues())), __LINE__);
        }
        $this->trunk = $trunk;
        return $this;
    }
    /**
     * Get trunkDirection value
     * @return string
     */
    public function getTrunkDirection()
    {
        return $this->trunkDirection;
    }
    /**
     * Set trunkDirection value
     * @uses XTrunkDirection::valueIsValid()
     * @uses XTrunkDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkDirection
     * @return XT1Port
     */
    public function setTrunkDirection($trunkDirection = null)
    {
        // validation for constraint: enumeration
        if (!XTrunkDirection::valueIsValid($trunkDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkDirection, implode(', ', XTrunkDirection::getValidValues())), __LINE__);
        }
        $this->trunkDirection = $trunkDirection;
        return $this;
    }
    /**
     * Get trunkLevel value
     * @return string
     */
    public function getTrunkLevel()
    {
        return $this->trunkLevel;
    }
    /**
     * Set trunkLevel value
     * @uses XTrunkLevel::valueIsValid()
     * @uses XTrunkLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkLevel
     * @return XT1Port
     */
    public function setTrunkLevel($trunkLevel = null)
    {
        // validation for constraint: enumeration
        if (!XTrunkLevel::valueIsValid($trunkLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkLevel, implode(', ', XTrunkLevel::getValidValues())), __LINE__);
        }
        $this->trunkLevel = $trunkLevel;
        return $this;
    }
    /**
     * Get trunkPadRx value
     * @return string
     */
    public function getTrunkPadRx()
    {
        return $this->trunkPadRx;
    }
    /**
     * Set trunkPadRx value
     * @uses XTrunkPad::valueIsValid()
     * @uses XTrunkPad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkPadRx
     * @return XT1Port
     */
    public function setTrunkPadRx($trunkPadRx = null)
    {
        // validation for constraint: enumeration
        if (!XTrunkPad::valueIsValid($trunkPadRx)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkPadRx, implode(', ', XTrunkPad::getValidValues())), __LINE__);
        }
        $this->trunkPadRx = $trunkPadRx;
        return $this;
    }
    /**
     * Get trunkPadTx value
     * @return string
     */
    public function getTrunkPadTx()
    {
        return $this->trunkPadTx;
    }
    /**
     * Set trunkPadTx value
     * @uses XTrunkPad::valueIsValid()
     * @uses XTrunkPad::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkPadTx
     * @return XT1Port
     */
    public function setTrunkPadTx($trunkPadTx = null)
    {
        // validation for constraint: enumeration
        if (!XTrunkPad::valueIsValid($trunkPadTx)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkPadTx, implode(', ', XTrunkPad::getValidValues())), __LINE__);
        }
        $this->trunkPadTx = $trunkPadTx;
        return $this;
    }
    /**
     * Get callerId value
     * @return string
     */
    public function getCallerId()
    {
        return $this->callerId;
    }
    /**
     * Set callerId value
     * @uses XCallerID::valueIsValid()
     * @uses XCallerID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerId
     * @return XT1Port
     */
    public function setCallerId($callerId = 'ANI')
    {
        // validation for constraint: enumeration
        if (!XCallerID::valueIsValid($callerId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callerId, implode(', ', XCallerID::getValidValues())), __LINE__);
        }
        $this->callerId = $callerId;
        return $this;
    }
    /**
     * Get attendantDn value
     * @return string|null
     */
    public function getAttendantDn()
    {
        return $this->attendantDn;
    }
    /**
     * Set attendantDn value
     * @param string $attendantDn
     * @return XT1Port
     */
    public function setAttendantDn($attendantDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attendantDn) && strlen($attendantDn) > 255) || (is_array($attendantDn) && count($attendantDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($attendantDn) ? strlen($attendantDn) : count($attendantDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attendantDn) && !is_string($attendantDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attendantDn)), __LINE__);
        }
        $this->attendantDn = $attendantDn;
        return $this;
    }
    /**
     * Get unattendedPort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return isset($this->unattendedPort) ? $this->unattendedPort : null;
    }
    /**
     * Set unattendedPort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unattendedPort
     * @return XT1Port
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        if (is_null($unattendedPort) || (is_array($unattendedPort) && empty($unattendedPort))) {
            unset($this->unattendedPort);
        } else {
            $this->unattendedPort = $unattendedPort;
        }
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return XT1Port
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 255) || (is_array($callerIdDn) && count($callerIdDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XVendorConfig $vendorConfig
     * @return XT1Port
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
    /**
     * Get endpointId value
     * @return string|null
     */
    public function getEndpointId()
    {
        return $this->endpointId;
    }
    /**
     * Set endpointId value
     * @param string $endpointId
     * @return XT1Port
     */
    public function setEndpointId($endpointId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($endpointId) && strlen($endpointId) > 128) || (is_array($endpointId) && count($endpointId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($endpointId) ? strlen($endpointId) : count($endpointId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endpointId) && !is_string($endpointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endpointId)), __LINE__);
        }
        $this->endpointId = $endpointId;
        return $this;
    }
    /**
     * Get timer1 value
     * @return string|null
     */
    public function getTimer1()
    {
        return $this->timer1;
    }
    /**
     * Set timer1 value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer1
     * @return XT1Port
     */
    public function setTimer1($timer1 = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timer1)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer1, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timer1 = $timer1;
        return $this;
    }
    /**
     * Get timer2 value
     * @return string|null
     */
    public function getTimer2()
    {
        return $this->timer2;
    }
    /**
     * Set timer2 value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer2
     * @return XT1Port
     */
    public function setTimer2($timer2 = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timer2)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer2, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timer2 = $timer2;
        return $this;
    }
    /**
     * Get timer3 value
     * @return string|null
     */
    public function getTimer3()
    {
        return $this->timer3;
    }
    /**
     * Set timer3 value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer3
     * @return XT1Port
     */
    public function setTimer3($timer3 = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timer3)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer3, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timer3 = $timer3;
        return $this;
    }
    /**
     * Get timer4 value
     * @return string|null
     */
    public function getTimer4()
    {
        return $this->timer4;
    }
    /**
     * Set timer4 value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer4
     * @return XT1Port
     */
    public function setTimer4($timer4 = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timer4)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer4, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timer4 = $timer4;
        return $this;
    }
    /**
     * Get timer5 value
     * @return string|null
     */
    public function getTimer5()
    {
        return $this->timer5;
    }
    /**
     * Set timer5 value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer5
     * @return XT1Port
     */
    public function setTimer5($timer5 = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timer5)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer5, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timer5 = $timer5;
        return $this;
    }
    /**
     * Get timer6 value
     * @return string|null
     */
    public function getTimer6()
    {
        return $this->timer6;
    }
    /**
     * Set timer6 value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timer6
     * @return XT1Port
     */
    public function setTimer6($timer6 = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timer6)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timer6, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timer6 = $timer6;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XT1Port
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
