<?php
/**
 * This class stands for XSubClass EnumType
 * @subpackage Enumerations
 */
class XSubClass
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'CTI Port'
     * @return string 'CTI Port'
     */
    const VALUE_CTI_PORT = 'CTI Port';
    /**
     * Constant for value 'H323 Phone'
     * @return string 'H323 Phone'
     */
    const VALUE_H_323_PHONE = 'H323 Phone';
    /**
     * Constant for value 'MGCP Stn'
     * @return string 'MGCP Stn'
     */
    const VALUE_MGCP_STN = 'MGCP Stn';
    /**
     * Constant for value 'MGCP Trunk'
     * @return string 'MGCP Trunk'
     */
    const VALUE_MGCP_TRUNK = 'MGCP Trunk';
    /**
     * Constant for value 'H323 GW'
     * @return string 'H323 GW'
     */
    const VALUE_H_323_GW = 'H323 GW';
    /**
     * Constant for value 'Conference Bridge'
     * @return string 'Conference Bridge'
     */
    const VALUE_CONFERENCE_BRIDGE = 'Conference Bridge';
    /**
     * Constant for value 'Conference Bridge WS-X6608'
     * @return string 'Conference Bridge WS-X6608'
     */
    const VALUE_CONFERENCE_BRIDGE_WS_X_6608 = 'Conference Bridge WS-X6608';
    /**
     * Constant for value 'Cisco IOS Conference Bridge (HDV2)'
     * @return string 'Cisco IOS Conference Bridge (HDV2)'
     */
    const VALUE_CISCO_IOS_CONFERENCE_BRIDGE_HDV_2 = 'Cisco IOS Conference Bridge (HDV2)';
    /**
     * Constant for value 'Cisco Conference Bridge (WS-SVC-CMM)'
     * @return string 'Cisco Conference Bridge (WS-SVC-CMM)'
     */
    const VALUE_CISCO_CONFERENCE_BRIDGE_WS_SVC_CMM = 'Cisco Conference Bridge (WS-SVC-CMM)';
    /**
     * Constant for value 'Cisco Media Server (WS-SVC-CMM-MS)'
     * @return string 'Cisco Media Server (WS-SVC-CMM-MS)'
     */
    const VALUE_CISCO_MEDIA_SERVER_WS_SVC_CMM_MS = 'Cisco Media Server (WS-SVC-CMM-MS)';
    /**
     * Constant for value 'Cisco Video Conference Bridge (IPVC-35xx)'
     * @return string 'Cisco Video Conference Bridge (IPVC-35xx)'
     */
    const VALUE_CISCO_VIDEO_CONFERENCE_BRIDGE_IPVC_35_XX = 'Cisco Video Conference Bridge (IPVC-35xx)';
    /**
     * Constant for value 'Music On Hold'
     * @return string 'Music On Hold'
     */
    const VALUE_MUSIC_ON_HOLD = 'Music On Hold';
    /**
     * Constant for value 'Device Pilot'
     * @return string 'Device Pilot'
     */
    const VALUE_DEVICE_PILOT = 'Device Pilot';
    /**
     * Constant for value 'CTI Route Point'
     * @return string 'CTI Route Point'
     */
    const VALUE_CTI_ROUTE_POINT = 'CTI Route Point';
    /**
     * Constant for value 'Voice Mail Port'
     * @return string 'Voice Mail Port'
     */
    const VALUE_VOICE_MAIL_PORT = 'Voice Mail Port';
    /**
     * Constant for value 'Route List'
     * @return string 'Route List'
     */
    const VALUE_ROUTE_LIST = 'Route List';
    /**
     * Constant for value 'Load Simulator'
     * @return string 'Load Simulator'
     */
    const VALUE_LOAD_SIMULATOR = 'Load Simulator';
    /**
     * Constant for value 'Media Termination Point'
     * @return string 'Media Termination Point'
     */
    const VALUE_MEDIA_TERMINATION_POINT = 'Media Termination Point';
    /**
     * Constant for value 'Media Termination Point Hardware'
     * @return string 'Media Termination Point Hardware'
     */
    const VALUE_MEDIA_TERMINATION_POINT_HARDWARE = 'Media Termination Point Hardware';
    /**
     * Constant for value 'Cisco IOS Software Media Termination Point (HDV2)'
     * @return string 'Cisco IOS Software Media Termination Point (HDV2)'
     */
    const VALUE_CISCO_IOS_SOFTWARE_MEDIA_TERMINATION_POINT_HDV_2 = 'Cisco IOS Software Media Termination Point (HDV2)';
    /**
     * Constant for value 'Cisco IOS Media Termination Point (HDV2)'
     * @return string 'Cisco IOS Media Termination Point (HDV2)'
     */
    const VALUE_CISCO_IOS_MEDIA_TERMINATION_POINT_HDV_2 = 'Cisco IOS Media Termination Point (HDV2)';
    /**
     * Constant for value 'Cisco Media Termination Point (WS-SVC-CMM)'
     * @return string 'Cisco Media Termination Point (WS-SVC-CMM)'
     */
    const VALUE_CISCO_MEDIA_TERMINATION_POINT_WS_SVC_CMM = 'Cisco Media Termination Point (WS-SVC-CMM)';
    /**
     * Constant for value 'GateKeeper'
     * @return string 'GateKeeper'
     */
    const VALUE_GATE_KEEPER = 'GateKeeper';
    /**
     * Constant for value 'Trunk'
     * @return string 'Trunk'
     */
    const VALUE_TRUNK = 'Trunk';
    /**
     * Constant for value 'SIP Trunk'
     * @return string 'SIP Trunk'
     */
    const VALUE_SIP_TRUNK = 'SIP Trunk';
    /**
     * Constant for value 'Tone Announcement Player'
     * @return string 'Tone Announcement Player'
     */
    const VALUE_TONE_ANNOUNCEMENT_PLAYER = 'Tone Announcement Player';
    /**
     * Constant for value 'Invalid'
     * @return string 'Invalid'
     */
    const VALUE_INVALID = 'Invalid';
    /**
     * Constant for value 'Cisco IOS Heterogeneous Video Conference Bridge'
     * @return string 'Cisco IOS Heterogeneous Video Conference Bridge'
     */
    const VALUE_CISCO_IOS_HETEROGENEOUS_VIDEO_CONFERENCE_BRIDGE = 'Cisco IOS Heterogeneous Video Conference Bridge';
    /**
     * Constant for value 'Cisco IOS Guaranteed Audio Video Conference Bridge'
     * @return string 'Cisco IOS Guaranteed Audio Video Conference Bridge'
     */
    const VALUE_CISCO_IOS_GUARANTEED_AUDIO_VIDEO_CONFERENCE_BRIDGE = 'Cisco IOS Guaranteed Audio Video Conference Bridge';
    /**
     * Constant for value 'Cisco IOS Homogeneous Video Conference Bridge'
     * @return string 'Cisco IOS Homogeneous Video Conference Bridge'
     */
    const VALUE_CISCO_IOS_HOMOGENEOUS_VIDEO_CONFERENCE_BRIDGE = 'Cisco IOS Homogeneous Video Conference Bridge';
    /**
     * Constant for value 'Cisco TelePresence MCU'
     * @return string 'Cisco TelePresence MCU'
     */
    const VALUE_CISCO_TELE_PRESENCE_MCU = 'Cisco TelePresence MCU';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_CTI_PORT
     * @uses self::VALUE_H_323_PHONE
     * @uses self::VALUE_MGCP_STN
     * @uses self::VALUE_MGCP_TRUNK
     * @uses self::VALUE_H_323_GW
     * @uses self::VALUE_CONFERENCE_BRIDGE
     * @uses self::VALUE_CONFERENCE_BRIDGE_WS_X_6608
     * @uses self::VALUE_CISCO_IOS_CONFERENCE_BRIDGE_HDV_2
     * @uses self::VALUE_CISCO_CONFERENCE_BRIDGE_WS_SVC_CMM
     * @uses self::VALUE_CISCO_MEDIA_SERVER_WS_SVC_CMM_MS
     * @uses self::VALUE_CISCO_VIDEO_CONFERENCE_BRIDGE_IPVC_35_XX
     * @uses self::VALUE_MUSIC_ON_HOLD
     * @uses self::VALUE_DEVICE_PILOT
     * @uses self::VALUE_CTI_ROUTE_POINT
     * @uses self::VALUE_VOICE_MAIL_PORT
     * @uses self::VALUE_ROUTE_LIST
     * @uses self::VALUE_LOAD_SIMULATOR
     * @uses self::VALUE_MEDIA_TERMINATION_POINT
     * @uses self::VALUE_MEDIA_TERMINATION_POINT_HARDWARE
     * @uses self::VALUE_CISCO_IOS_SOFTWARE_MEDIA_TERMINATION_POINT_HDV_2
     * @uses self::VALUE_CISCO_IOS_MEDIA_TERMINATION_POINT_HDV_2
     * @uses self::VALUE_CISCO_MEDIA_TERMINATION_POINT_WS_SVC_CMM
     * @uses self::VALUE_GATE_KEEPER
     * @uses self::VALUE_TRUNK
     * @uses self::VALUE_SIP_TRUNK
     * @uses self::VALUE_TONE_ANNOUNCEMENT_PLAYER
     * @uses self::VALUE_INVALID
     * @uses self::VALUE_CISCO_IOS_HETEROGENEOUS_VIDEO_CONFERENCE_BRIDGE
     * @uses self::VALUE_CISCO_IOS_GUARANTEED_AUDIO_VIDEO_CONFERENCE_BRIDGE
     * @uses self::VALUE_CISCO_IOS_HOMOGENEOUS_VIDEO_CONFERENCE_BRIDGE
     * @uses self::VALUE_CISCO_TELE_PRESENCE_MCU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_CTI_PORT,
            self::VALUE_H_323_PHONE,
            self::VALUE_MGCP_STN,
            self::VALUE_MGCP_TRUNK,
            self::VALUE_H_323_GW,
            self::VALUE_CONFERENCE_BRIDGE,
            self::VALUE_CONFERENCE_BRIDGE_WS_X_6608,
            self::VALUE_CISCO_IOS_CONFERENCE_BRIDGE_HDV_2,
            self::VALUE_CISCO_CONFERENCE_BRIDGE_WS_SVC_CMM,
            self::VALUE_CISCO_MEDIA_SERVER_WS_SVC_CMM_MS,
            self::VALUE_CISCO_VIDEO_CONFERENCE_BRIDGE_IPVC_35_XX,
            self::VALUE_MUSIC_ON_HOLD,
            self::VALUE_DEVICE_PILOT,
            self::VALUE_CTI_ROUTE_POINT,
            self::VALUE_VOICE_MAIL_PORT,
            self::VALUE_ROUTE_LIST,
            self::VALUE_LOAD_SIMULATOR,
            self::VALUE_MEDIA_TERMINATION_POINT,
            self::VALUE_MEDIA_TERMINATION_POINT_HARDWARE,
            self::VALUE_CISCO_IOS_SOFTWARE_MEDIA_TERMINATION_POINT_HDV_2,
            self::VALUE_CISCO_IOS_MEDIA_TERMINATION_POINT_HDV_2,
            self::VALUE_CISCO_MEDIA_TERMINATION_POINT_WS_SVC_CMM,
            self::VALUE_GATE_KEEPER,
            self::VALUE_TRUNK,
            self::VALUE_SIP_TRUNK,
            self::VALUE_TONE_ANNOUNCEMENT_PLAYER,
            self::VALUE_INVALID,
            self::VALUE_CISCO_IOS_HETEROGENEOUS_VIDEO_CONFERENCE_BRIDGE,
            self::VALUE_CISCO_IOS_GUARANTEED_AUDIO_VIDEO_CONFERENCE_BRIDGE,
            self::VALUE_CISCO_IOS_HOMOGENEOUS_VIDEO_CONFERENCE_BRIDGE,
            self::VALUE_CISCO_TELE_PRESENCE_MCU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
