<?php
/**
 * This class stands for XSoftkey EnumType
 * @subpackage Enumerations
 */
class XSoftkey
{
    /**
     * Constant for value 'Undefined'
     * @return string 'Undefined'
     */
    const VALUE_UNDEFINED = 'Undefined';
    /**
     * Constant for value 'Redial'
     * @return string 'Redial'
     */
    const VALUE_REDIAL = 'Redial';
    /**
     * Constant for value 'NewCall'
     * @return string 'NewCall'
     */
    const VALUE_NEW_CALL = 'NewCall';
    /**
     * Constant for value 'Hold'
     * @return string 'Hold'
     */
    const VALUE_HOLD = 'Hold';
    /**
     * Constant for value 'Transfer'
     * @return string 'Transfer'
     */
    const VALUE_TRANSFER = 'Transfer';
    /**
     * Constant for value 'Forward All'
     * @return string 'Forward All'
     */
    const VALUE_FORWARD_ALL = 'Forward All';
    /**
     * Constant for value 'Forward Busy'
     * @return string 'Forward Busy'
     */
    const VALUE_FORWARD_BUSY = 'Forward Busy';
    /**
     * Constant for value 'Forward No Answer'
     * @return string 'Forward No Answer'
     */
    const VALUE_FORWARD_NO_ANSWER = 'Forward No Answer';
    /**
     * Constant for value 'Backward'
     * @return string 'Backward'
     */
    const VALUE_BACKWARD = 'Backward';
    /**
     * Constant for value 'End Call'
     * @return string 'End Call'
     */
    const VALUE_END_CALL = 'End Call';
    /**
     * Constant for value 'Resume'
     * @return string 'Resume'
     */
    const VALUE_RESUME = 'Resume';
    /**
     * Constant for value 'Answer'
     * @return string 'Answer'
     */
    const VALUE_ANSWER = 'Answer';
    /**
     * Constant for value 'Info'
     * @return string 'Info'
     */
    const VALUE_INFO = 'Info';
    /**
     * Constant for value 'Conference'
     * @return string 'Conference'
     */
    const VALUE_CONFERENCE = 'Conference';
    /**
     * Constant for value 'Park'
     * @return string 'Park'
     */
    const VALUE_PARK = 'Park';
    /**
     * Constant for value 'Join'
     * @return string 'Join'
     */
    const VALUE_JOIN = 'Join';
    /**
     * Constant for value 'Meet Me'
     * @return string 'Meet Me'
     */
    const VALUE_MEET_ME = 'Meet Me';
    /**
     * Constant for value 'Pick Up'
     * @return string 'Pick Up'
     */
    const VALUE_PICK_UP = 'Pick Up';
    /**
     * Constant for value 'Group Pick Up'
     * @return string 'Group Pick Up'
     */
    const VALUE_GROUP_PICK_UP = 'Group Pick Up';
    /**
     * Constant for value 'Remove Last Conference Party'
     * @return string 'Remove Last Conference Party'
     */
    const VALUE_REMOVE_LAST_CONFERENCE_PARTY = 'Remove Last Conference Party';
    /**
     * Constant for value 'Call Back'
     * @return string 'Call Back'
     */
    const VALUE_CALL_BACK = 'Call Back';
    /**
     * Constant for value 'Barge'
     * @return string 'Barge'
     */
    const VALUE_BARGE = 'Barge';
    /**
     * Constant for value 'Quality Report Tool'
     * @return string 'Quality Report Tool'
     */
    const VALUE_QUALITY_REPORT_TOOL = 'Quality Report Tool';
    /**
     * Constant for value 'Toggle Malicious Call Trace'
     * @return string 'Toggle Malicious Call Trace'
     */
    const VALUE_TOGGLE_MALICIOUS_CALL_TRACE = 'Toggle Malicious Call Trace';
    /**
     * Constant for value 'Direct Transfer'
     * @return string 'Direct Transfer'
     */
    const VALUE_DIRECT_TRANSFER = 'Direct Transfer';
    /**
     * Constant for value 'Select'
     * @return string 'Select'
     */
    const VALUE_SELECT = 'Select';
    /**
     * Constant for value 'Conference List'
     * @return string 'Conference List'
     */
    const VALUE_CONFERENCE_LIST = 'Conference List';
    /**
     * Constant for value 'Immediate Divert'
     * @return string 'Immediate Divert'
     */
    const VALUE_IMMEDIATE_DIVERT = 'Immediate Divert';
    /**
     * Constant for value 'Conference Barge'
     * @return string 'Conference Barge'
     */
    const VALUE_CONFERENCE_BARGE = 'Conference Barge';
    /**
     * Constant for value 'Video Mode Command'
     * @return string 'Video Mode Command'
     */
    const VALUE_VIDEO_MODE_COMMAND = 'Video Mode Command';
    /**
     * Constant for value 'Other Pickup'
     * @return string 'Other Pickup'
     */
    const VALUE_OTHER_PICKUP = 'Other Pickup';
    /**
     * Constant for value 'HLog'
     * @return string 'HLog'
     */
    const VALUE_HLOG = 'HLog';
    /**
     * Constant for value 'Reject'
     * @return string 'Reject'
     */
    const VALUE_REJECT = 'Reject';
    /**
     * Constant for value 'Mobility'
     * @return string 'Mobility'
     */
    const VALUE_MOBILITY = 'Mobility';
    /**
     * Constant for value 'Redirect'
     * @return string 'Redirect'
     */
    const VALUE_REDIRECT = 'Redirect';
    /**
     * Constant for value 'Intercept'
     * @return string 'Intercept'
     */
    const VALUE_INTERCEPT = 'Intercept';
    /**
     * Constant for value 'Toggle Watch On/Off'
     * @return string 'Toggle Watch On/Off'
     */
    const VALUE_TOGGLE_WATCH_ON_OFF = 'Toggle Watch On/Off';
    /**
     * Constant for value 'Transfer to Voice Mail'
     * @return string 'Transfer to Voice Mail'
     */
    const VALUE_TRANSFER_TO_VOICE_MAIL = 'Transfer to Voice Mail';
    /**
     * Constant for value 'Toggle Do Not Disturb'
     * @return string 'Toggle Do Not Disturb'
     */
    const VALUE_TOGGLE_DO_NOT_DISTURB = 'Toggle Do Not Disturb';
    /**
     * Constant for value 'Toggle Send All Calls'
     * @return string 'Toggle Send All Calls'
     */
    const VALUE_TOGGLE_SEND_ALL_CALLS = 'Toggle Send All Calls';
    /**
     * Constant for value 'Abbreviated Dial'
     * @return string 'Abbreviated Dial'
     */
    const VALUE_ABBREVIATED_DIAL = 'Abbreviated Dial';
    /**
     * Constant for value 'Cancel Call Waiting'
     * @return string 'Cancel Call Waiting'
     */
    const VALUE_CANCEL_CALL_WAITING = 'Cancel Call Waiting';
    /**
     * Constant for value 'Record'
     * @return string 'Record'
     */
    const VALUE_RECORD = 'Record';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_REDIAL
     * @uses self::VALUE_NEW_CALL
     * @uses self::VALUE_HOLD
     * @uses self::VALUE_TRANSFER
     * @uses self::VALUE_FORWARD_ALL
     * @uses self::VALUE_FORWARD_BUSY
     * @uses self::VALUE_FORWARD_NO_ANSWER
     * @uses self::VALUE_BACKWARD
     * @uses self::VALUE_END_CALL
     * @uses self::VALUE_RESUME
     * @uses self::VALUE_ANSWER
     * @uses self::VALUE_INFO
     * @uses self::VALUE_CONFERENCE
     * @uses self::VALUE_PARK
     * @uses self::VALUE_JOIN
     * @uses self::VALUE_MEET_ME
     * @uses self::VALUE_PICK_UP
     * @uses self::VALUE_GROUP_PICK_UP
     * @uses self::VALUE_REMOVE_LAST_CONFERENCE_PARTY
     * @uses self::VALUE_CALL_BACK
     * @uses self::VALUE_BARGE
     * @uses self::VALUE_QUALITY_REPORT_TOOL
     * @uses self::VALUE_TOGGLE_MALICIOUS_CALL_TRACE
     * @uses self::VALUE_DIRECT_TRANSFER
     * @uses self::VALUE_SELECT
     * @uses self::VALUE_CONFERENCE_LIST
     * @uses self::VALUE_IMMEDIATE_DIVERT
     * @uses self::VALUE_CONFERENCE_BARGE
     * @uses self::VALUE_VIDEO_MODE_COMMAND
     * @uses self::VALUE_OTHER_PICKUP
     * @uses self::VALUE_HLOG
     * @uses self::VALUE_REJECT
     * @uses self::VALUE_MOBILITY
     * @uses self::VALUE_REDIRECT
     * @uses self::VALUE_INTERCEPT
     * @uses self::VALUE_TOGGLE_WATCH_ON_OFF
     * @uses self::VALUE_TRANSFER_TO_VOICE_MAIL
     * @uses self::VALUE_TOGGLE_DO_NOT_DISTURB
     * @uses self::VALUE_TOGGLE_SEND_ALL_CALLS
     * @uses self::VALUE_ABBREVIATED_DIAL
     * @uses self::VALUE_CANCEL_CALL_WAITING
     * @uses self::VALUE_RECORD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNDEFINED,
            self::VALUE_REDIAL,
            self::VALUE_NEW_CALL,
            self::VALUE_HOLD,
            self::VALUE_TRANSFER,
            self::VALUE_FORWARD_ALL,
            self::VALUE_FORWARD_BUSY,
            self::VALUE_FORWARD_NO_ANSWER,
            self::VALUE_BACKWARD,
            self::VALUE_END_CALL,
            self::VALUE_RESUME,
            self::VALUE_ANSWER,
            self::VALUE_INFO,
            self::VALUE_CONFERENCE,
            self::VALUE_PARK,
            self::VALUE_JOIN,
            self::VALUE_MEET_ME,
            self::VALUE_PICK_UP,
            self::VALUE_GROUP_PICK_UP,
            self::VALUE_REMOVE_LAST_CONFERENCE_PARTY,
            self::VALUE_CALL_BACK,
            self::VALUE_BARGE,
            self::VALUE_QUALITY_REPORT_TOOL,
            self::VALUE_TOGGLE_MALICIOUS_CALL_TRACE,
            self::VALUE_DIRECT_TRANSFER,
            self::VALUE_SELECT,
            self::VALUE_CONFERENCE_LIST,
            self::VALUE_IMMEDIATE_DIVERT,
            self::VALUE_CONFERENCE_BARGE,
            self::VALUE_VIDEO_MODE_COMMAND,
            self::VALUE_OTHER_PICKUP,
            self::VALUE_HLOG,
            self::VALUE_REJECT,
            self::VALUE_MOBILITY,
            self::VALUE_REDIRECT,
            self::VALUE_INTERCEPT,
            self::VALUE_TOGGLE_WATCH_ON_OFF,
            self::VALUE_TRANSFER_TO_VOICE_MAIL,
            self::VALUE_TOGGLE_DO_NOT_DISTURB,
            self::VALUE_TOGGLE_SEND_ALL_CALLS,
            self::VALUE_ABBREVIATED_DIAL,
            self::VALUE_CANCEL_CALL_WAITING,
            self::VALUE_RECORD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
