<?php
/**
 * This class stands for XScheduleUnit EnumType
 * @subpackage Enumerations
 */
class XScheduleUnit
{
    /**
     * Constant for value 'HOUR'
     * @return string 'HOUR'
     */
    const VALUE_HOUR = 'HOUR';
    /**
     * Constant for value 'DAY'
     * @return string 'DAY'
     */
    const VALUE_DAY = 'DAY';
    /**
     * Constant for value 'WEEK'
     * @return string 'WEEK'
     */
    const VALUE_WEEK = 'WEEK';
    /**
     * Constant for value 'MONTH'
     * @return string 'MONTH'
     */
    const VALUE_MONTH = 'MONTH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HOUR
     * @uses self::VALUE_DAY
     * @uses self::VALUE_WEEK
     * @uses self::VALUE_MONTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HOUR,
            self::VALUE_DAY,
            self::VALUE_WEEK,
            self::VALUE_MONTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
