<?php
/**
 * This class stands for XSPA8800Port EnumType
 * @subpackage Enumerations
 */
class XSPA8800Port
{
    /**
     * Constant for value 'Phone 1'
     * @return string 'Phone 1'
     */
    const VALUE_PHONE_1 = 'Phone 1';
    /**
     * Constant for value 'Line 1'
     * @return string 'Line 1'
     */
    const VALUE_LINE_1 = 'Line 1';
    /**
     * Constant for value 'Phone 2'
     * @return string 'Phone 2'
     */
    const VALUE_PHONE_2 = 'Phone 2';
    /**
     * Constant for value 'Line 2'
     * @return string 'Line 2'
     */
    const VALUE_LINE_2 = 'Line 2';
    /**
     * Constant for value 'Phone 3'
     * @return string 'Phone 3'
     */
    const VALUE_PHONE_3 = 'Phone 3';
    /**
     * Constant for value 'Line 3'
     * @return string 'Line 3'
     */
    const VALUE_LINE_3 = 'Line 3';
    /**
     * Constant for value 'Phone 4'
     * @return string 'Phone 4'
     */
    const VALUE_PHONE_4 = 'Phone 4';
    /**
     * Constant for value 'Line 4'
     * @return string 'Line 4'
     */
    const VALUE_LINE_4 = 'Line 4';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PHONE_1
     * @uses self::VALUE_LINE_1
     * @uses self::VALUE_PHONE_2
     * @uses self::VALUE_LINE_2
     * @uses self::VALUE_PHONE_3
     * @uses self::VALUE_LINE_3
     * @uses self::VALUE_PHONE_4
     * @uses self::VALUE_LINE_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PHONE_1,
            self::VALUE_LINE_1,
            self::VALUE_PHONE_2,
            self::VALUE_LINE_2,
            self::VALUE_PHONE_3,
            self::VALUE_LINE_3,
            self::VALUE_PHONE_4,
            self::VALUE_LINE_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
