<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSIPNormalizationScript StructType
 * @subpackage Structs
 */
class XSIPNormalizationScript extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $content;
    /**
     * The scriptExecutionErrorRecoveryAction
     * Meta informations extracted from the WSDL
     * - default: Message Rollback Only
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $scriptExecutionErrorRecoveryAction;
    /**
     * The systemResourceErrorRecoveryAction
     * Meta informations extracted from the WSDL
     * - default: Disable Script
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $systemResourceErrorRecoveryAction;
    /**
     * The maxMemoryThreshold
     * Meta informations extracted from the WSDL
     * - default: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $maxMemoryThreshold;
    /**
     * The maxLuaInstructionsThreshold
     * Meta informations extracted from the WSDL
     * - default: 1000
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $maxLuaInstructionsThreshold;
    /**
     * The isStandard
     * Meta informations extracted from the WSDL
     * - documentation: If the value of isStandard is t (true), the fields are not editable.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isStandard;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for XSIPNormalizationScript
     * @uses XSIPNormalizationScript::setName()
     * @uses XSIPNormalizationScript::setContent()
     * @uses XSIPNormalizationScript::setScriptExecutionErrorRecoveryAction()
     * @uses XSIPNormalizationScript::setSystemResourceErrorRecoveryAction()
     * @uses XSIPNormalizationScript::setMaxMemoryThreshold()
     * @uses XSIPNormalizationScript::setMaxLuaInstructionsThreshold()
     * @uses XSIPNormalizationScript::setIsStandard()
     * @uses XSIPNormalizationScript::setDescription()
     * @param string $name
     * @param string $content
     * @param string $scriptExecutionErrorRecoveryAction
     * @param string $systemResourceErrorRecoveryAction
     * @param string $maxMemoryThreshold
     * @param string $maxLuaInstructionsThreshold
     * @param string $isStandard
     * @param string $description
     */
    public function __construct($name = null, $content = null, $scriptExecutionErrorRecoveryAction = 'Message Rollback Only', $systemResourceErrorRecoveryAction = 'Disable Script', $maxMemoryThreshold = '50', $maxLuaInstructionsThreshold = '1000', $isStandard = null, $description = null)
    {
        $this
            ->setName($name)
            ->setContent($content)
            ->setScriptExecutionErrorRecoveryAction($scriptExecutionErrorRecoveryAction)
            ->setSystemResourceErrorRecoveryAction($systemResourceErrorRecoveryAction)
            ->setMaxMemoryThreshold($maxMemoryThreshold)
            ->setMaxLuaInstructionsThreshold($maxLuaInstructionsThreshold)
            ->setIsStandard($isStandard)
            ->setDescription($description);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XSIPNormalizationScript
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get content value
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return XSIPNormalizationScript
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get scriptExecutionErrorRecoveryAction value
     * @return string
     */
    public function getScriptExecutionErrorRecoveryAction()
    {
        return $this->scriptExecutionErrorRecoveryAction;
    }
    /**
     * Set scriptExecutionErrorRecoveryAction value
     * @uses XSIPScriptErrorHandling::valueIsValid()
     * @uses XSIPScriptErrorHandling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scriptExecutionErrorRecoveryAction
     * @return XSIPNormalizationScript
     */
    public function setScriptExecutionErrorRecoveryAction($scriptExecutionErrorRecoveryAction = 'Message Rollback Only')
    {
        // validation for constraint: enumeration
        if (!XSIPScriptErrorHandling::valueIsValid($scriptExecutionErrorRecoveryAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scriptExecutionErrorRecoveryAction, implode(', ', XSIPScriptErrorHandling::getValidValues())), __LINE__);
        }
        $this->scriptExecutionErrorRecoveryAction = $scriptExecutionErrorRecoveryAction;
        return $this;
    }
    /**
     * Get systemResourceErrorRecoveryAction value
     * @return string
     */
    public function getSystemResourceErrorRecoveryAction()
    {
        return $this->systemResourceErrorRecoveryAction;
    }
    /**
     * Set systemResourceErrorRecoveryAction value
     * @uses XSIPScriptErrorHandling::valueIsValid()
     * @uses XSIPScriptErrorHandling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $systemResourceErrorRecoveryAction
     * @return XSIPNormalizationScript
     */
    public function setSystemResourceErrorRecoveryAction($systemResourceErrorRecoveryAction = 'Disable Script')
    {
        // validation for constraint: enumeration
        if (!XSIPScriptErrorHandling::valueIsValid($systemResourceErrorRecoveryAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $systemResourceErrorRecoveryAction, implode(', ', XSIPScriptErrorHandling::getValidValues())), __LINE__);
        }
        $this->systemResourceErrorRecoveryAction = $systemResourceErrorRecoveryAction;
        return $this;
    }
    /**
     * Get maxMemoryThreshold value
     * @return string
     */
    public function getMaxMemoryThreshold()
    {
        return $this->maxMemoryThreshold;
    }
    /**
     * Set maxMemoryThreshold value
     * @param string $maxMemoryThreshold
     * @return XSIPNormalizationScript
     */
    public function setMaxMemoryThreshold($maxMemoryThreshold = '50')
    {
        // validation for constraint: string
        if (!is_null($maxMemoryThreshold) && !is_string($maxMemoryThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxMemoryThreshold)), __LINE__);
        }
        $this->maxMemoryThreshold = $maxMemoryThreshold;
        return $this;
    }
    /**
     * Get maxLuaInstructionsThreshold value
     * @return string
     */
    public function getMaxLuaInstructionsThreshold()
    {
        return $this->maxLuaInstructionsThreshold;
    }
    /**
     * Set maxLuaInstructionsThreshold value
     * @param string $maxLuaInstructionsThreshold
     * @return XSIPNormalizationScript
     */
    public function setMaxLuaInstructionsThreshold($maxLuaInstructionsThreshold = '1000')
    {
        // validation for constraint: string
        if (!is_null($maxLuaInstructionsThreshold) && !is_string($maxLuaInstructionsThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxLuaInstructionsThreshold)), __LINE__);
        }
        $this->maxLuaInstructionsThreshold = $maxLuaInstructionsThreshold;
        return $this;
    }
    /**
     * Get isStandard value
     * @return string
     */
    public function getIsStandard()
    {
        return $this->isStandard;
    }
    /**
     * Set isStandard value
     * @param string $isStandard
     * @return XSIPNormalizationScript
     */
    public function setIsStandard($isStandard = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isStandard) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isStandard, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isStandard) && !is_string($isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isStandard)), __LINE__);
        }
        $this->isStandard = $isStandard;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XSIPNormalizationScript
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XSIPNormalizationScript
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
