<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRoutePlan StructType
 * @subpackage Structs
 */
class XRoutePlan extends AbstractStructBase
{
    /**
     * The dnOrPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $dnOrPattern;
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $partition;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $type;
    /**
     * The routeDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $routeDetail;
    /**
     * Constructor method for XRoutePlan
     * @uses XRoutePlan::setDnOrPattern()
     * @uses XRoutePlan::setPartition()
     * @uses XRoutePlan::setType()
     * @uses XRoutePlan::setRouteDetail()
     * @param string $dnOrPattern
     * @param XFkType $partition
     * @param string $type
     * @param string $routeDetail
     */
    public function __construct($dnOrPattern = null, XFkType $partition = null, $type = null, $routeDetail = null)
    {
        $this
            ->setDnOrPattern($dnOrPattern)
            ->setPartition($partition)
            ->setType($type)
            ->setRouteDetail($routeDetail);
    }
    /**
     * Get dnOrPattern value
     * @return string
     */
    public function getDnOrPattern()
    {
        return $this->dnOrPattern;
    }
    /**
     * Set dnOrPattern value
     * @param string $dnOrPattern
     * @return XRoutePlan
     */
    public function setDnOrPattern($dnOrPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dnOrPattern) && strlen($dnOrPattern) > 255) || (is_array($dnOrPattern) && count($dnOrPattern) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($dnOrPattern) ? strlen($dnOrPattern) : count($dnOrPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dnOrPattern) && !is_string($dnOrPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dnOrPattern)), __LINE__);
        }
        $this->dnOrPattern = $dnOrPattern;
        return $this;
    }
    /**
     * Get partition value
     * @return XFkType
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param XFkType $partition
     * @return XRoutePlan
     */
    public function setPartition(XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses XPatternUsage::valueIsValid()
     * @uses XPatternUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return XRoutePlan
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!XPatternUsage::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', XPatternUsage::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get routeDetail value
     * @return string
     */
    public function getRouteDetail()
    {
        return $this->routeDetail;
    }
    /**
     * Set routeDetail value
     * @param string $routeDetail
     * @return XRoutePlan
     */
    public function setRouteDetail($routeDetail = null)
    {
        // validation for constraint: string
        if (!is_null($routeDetail) && !is_string($routeDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeDetail)), __LINE__);
        }
        $this->routeDetail = $routeDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XRoutePlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
