<?php
/**
 * This class stands for XResourceOpMode EnumType
 * @subpackage Enumerations
 */
class XResourceOpMode
{
    /**
     * Constant for value 'Read'
     * @return string 'Read'
     */
    const VALUE_READ = 'Read';
    /**
     * Constant for value 'Create'
     * @return string 'Create'
     */
    const VALUE_CREATE = 'Create';
    /**
     * Constant for value 'Update'
     * @return string 'Update'
     */
    const VALUE_UPDATE = 'Update';
    /**
     * Constant for value 'Delete'
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Constant for value 'Head'
     * @return string 'Head'
     */
    const VALUE_HEAD = 'Head';
    /**
     * Constant for value 'Options'
     * @return string 'Options'
     */
    const VALUE_OPTIONS = 'Options';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_READ
     * @uses self::VALUE_CREATE
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_HEAD
     * @uses self::VALUE_OPTIONS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_READ,
            self::VALUE_CREATE,
            self::VALUE_UPDATE,
            self::VALUE_DELETE,
            self::VALUE_HEAD,
            self::VALUE_OPTIONS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
