<?php
/**
 * This class stands for XRTMTReportingService EnumType
 * @subpackage Enumerations
 */
class XRTMTReportingService
{
    /**
     * Constant for value 'CCD Learned Pattern'
     * @return string 'CCD Learned Pattern'
     */
    const VALUE_CCD_LEARNED_PATTERN = 'CCD Learned Pattern';
    /**
     * Constant for value 'SAF Forwarder'
     * @return string 'SAF Forwarder'
     */
    const VALUE_SAF_FORWARDER = 'SAF Forwarder';
    /**
     * Constant for value 'CCD Learned Pattern For DNA'
     * @return string 'CCD Learned Pattern For DNA'
     */
    const VALUE_CCD_LEARNED_PATTERN_FOR_DNA = 'CCD Learned Pattern For DNA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CCD_LEARNED_PATTERN
     * @uses self::VALUE_SAF_FORWARDER
     * @uses self::VALUE_CCD_LEARNED_PATTERN_FOR_DNA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CCD_LEARNED_PATTERN,
            self::VALUE_SAF_FORWARDER,
            self::VALUE_CCD_LEARNED_PATTERN_FOR_DNA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
