<?php
/**
 * This class stands for XQSIG EnumType
 * @subpackage Enumerations
 */
class XQSIG
{
    /**
     * Constant for value 'Not Initialized'
     * @return string 'Not Initialized'
     */
    const VALUE_NOT_INITIALIZED = 'Not Initialized';
    /**
     * Constant for value 'All PRI QSIG'
     * @return string 'All PRI QSIG'
     */
    const VALUE_ALL_PRI_QSIG = 'All PRI QSIG';
    /**
     * Constant for value 'Miscible Mix'
     * @return string 'Miscible Mix'
     */
    const VALUE_MISCIBLE_MIX = 'Miscible Mix';
    /**
     * Constant for value 'H.323 Gateways'
     * @return string 'H.323 Gateways'
     */
    const VALUE_H_323_GATEWAYS = 'H.323 Gateways';
    /**
     * Constant for value 'Mixed non-QSIG'
     * @return string 'Mixed non-QSIG'
     */
    const VALUE_MIXED_NON_QSIG = 'Mixed non-QSIG';
    /**
     * Constant for value 'Invalid group configuration'
     * @return string 'Invalid group configuration'
     */
    const VALUE_INVALID_GROUP_CONFIGURATION = 'Invalid group configuration';
    /**
     * Constant for value 'All SIP'
     * @return string 'All SIP'
     */
    const VALUE_ALL_SIP = 'All SIP';
    /**
     * Constant for value 'Mixed SIP'
     * @return string 'Mixed SIP'
     */
    const VALUE_MIXED_SIP = 'Mixed SIP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_INITIALIZED
     * @uses self::VALUE_ALL_PRI_QSIG
     * @uses self::VALUE_MISCIBLE_MIX
     * @uses self::VALUE_H_323_GATEWAYS
     * @uses self::VALUE_MIXED_NON_QSIG
     * @uses self::VALUE_INVALID_GROUP_CONFIGURATION
     * @uses self::VALUE_ALL_SIP
     * @uses self::VALUE_MIXED_SIP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_INITIALIZED,
            self::VALUE_ALL_PRI_QSIG,
            self::VALUE_MISCIBLE_MIX,
            self::VALUE_H_323_GATEWAYS,
            self::VALUE_MIXED_NON_QSIG,
            self::VALUE_INVALID_GROUP_CONFIGURATION,
            self::VALUE_ALL_SIP,
            self::VALUE_MIXED_SIP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
