<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPresenceGroup StructType
 * @subpackage Structs
 */
class XPresenceGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The presenceGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PresenceGroups
     */
    public $presenceGroups;
    /**
     * Constructor method for XPresenceGroup
     * @uses XPresenceGroup::setName()
     * @uses XPresenceGroup::setDescription()
     * @uses XPresenceGroup::setPresenceGroups()
     * @param string $name
     * @param string $description
     * @param PresenceGroups $presenceGroups
     */
    public function __construct($name = null, $description = null, PresenceGroups $presenceGroups = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setPresenceGroups($presenceGroups);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XPresenceGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return XPresenceGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get presenceGroups value
     * @return PresenceGroups|null
     */
    public function getPresenceGroups()
    {
        return $this->presenceGroups;
    }
    /**
     * Set presenceGroups value
     * @param PresenceGroups $presenceGroups
     * @return XPresenceGroup
     */
    public function setPresenceGroups(PresenceGroups $presenceGroups = null)
    {
        $this->presenceGroups = $presenceGroups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XPresenceGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
