<?php
/**
 * This class stands for XPhoneTemplateUsage EnumType
 * @subpackage Enumerations
 */
class XPhoneTemplateUsage
{
    /**
     * Constant for value 'Traditional Phone Template'
     * @return string 'Traditional Phone Template'
     */
    const VALUE_TRADITIONAL_PHONE_TEMPLATE = 'Traditional Phone Template';
    /**
     * Constant for value 'Side Car 14-Buttons'
     * @return string 'Side Car 14-Buttons'
     */
    const VALUE_SIDE_CAR_14_BUTTONS = 'Side Car 14-Buttons';
    /**
     * Constant for value '7915 Side Car 12-Buttons'
     * @return string '7915 Side Car 12-Buttons'
     */
    const VALUE_7915_SIDE_CAR_12_BUTTONS = '7915 Side Car 12-Buttons';
    /**
     * Constant for value '7915 Side Car 24-Buttons'
     * @return string '7915 Side Car 24-Buttons'
     */
    const VALUE_7915_SIDE_CAR_24_BUTTONS = '7915 Side Car 24-Buttons';
    /**
     * Constant for value '7916 Side Car 12-Buttons'
     * @return string '7916 Side Car 12-Buttons'
     */
    const VALUE_7916_SIDE_CAR_12_BUTTONS = '7916 Side Car 12-Buttons';
    /**
     * Constant for value '7916 Side Car 24-Buttons'
     * @return string '7916 Side Car 24-Buttons'
     */
    const VALUE_7916_SIDE_CAR_24_BUTTONS = '7916 Side Car 24-Buttons';
    /**
     * Constant for value 'CKEM 36-Buttons'
     * @return string 'CKEM 36-Buttons'
     */
    const VALUE_CKEM_36_BUTTONS = 'CKEM 36-Buttons';
    /**
     * Constant for value 'VKEM 36-Buttons'
     * @return string 'VKEM 36-Buttons'
     */
    const VALUE_VKEM_36_BUTTONS = 'VKEM 36-Buttons';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRADITIONAL_PHONE_TEMPLATE
     * @uses self::VALUE_SIDE_CAR_14_BUTTONS
     * @uses self::VALUE_7915_SIDE_CAR_12_BUTTONS
     * @uses self::VALUE_7915_SIDE_CAR_24_BUTTONS
     * @uses self::VALUE_7916_SIDE_CAR_12_BUTTONS
     * @uses self::VALUE_7916_SIDE_CAR_24_BUTTONS
     * @uses self::VALUE_CKEM_36_BUTTONS
     * @uses self::VALUE_VKEM_36_BUTTONS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRADITIONAL_PHONE_TEMPLATE,
            self::VALUE_SIDE_CAR_14_BUTTONS,
            self::VALUE_7915_SIDE_CAR_12_BUTTONS,
            self::VALUE_7915_SIDE_CAR_24_BUTTONS,
            self::VALUE_7916_SIDE_CAR_12_BUTTONS,
            self::VALUE_7916_SIDE_CAR_24_BUTTONS,
            self::VALUE_CKEM_36_BUTTONS,
            self::VALUE_VKEM_36_BUTTONS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
