<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPhoneSecurityProfile StructType
 * @subpackage Structs
 */
class XPhoneSecurityProfile extends AbstractStructBase
{
    /**
     * The phoneType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $phoneType;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $protocol;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The deviceSecurityMode
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - default: By Null String
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - default: 1024
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The tftpEncryptedConfig
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $tftpEncryptedConfig;
    /**
     * The nonceValidityTime
     * Meta informations extracted from the WSDL
     * - default: 600
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nonceValidityTime;
    /**
     * The transportType
     * Meta informations extracted from the WSDL
     * - default: TCP+UDP
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $transportType;
    /**
     * The sipPhonePort
     * Meta informations extracted from the WSDL
     * - default: 5060
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPhonePort;
    /**
     * The enableDigestAuthentication
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDigestAuthentication;
    /**
     * The excludeDigestCredentials
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Applicable only for sip phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $excludeDigestCredentials;
    /**
     * Constructor method for XPhoneSecurityProfile
     * @uses XPhoneSecurityProfile::setPhoneType()
     * @uses XPhoneSecurityProfile::setProtocol()
     * @uses XPhoneSecurityProfile::setName()
     * @uses XPhoneSecurityProfile::setDescription()
     * @uses XPhoneSecurityProfile::setDeviceSecurityMode()
     * @uses XPhoneSecurityProfile::setAuthenticationMode()
     * @uses XPhoneSecurityProfile::setKeySize()
     * @uses XPhoneSecurityProfile::setTftpEncryptedConfig()
     * @uses XPhoneSecurityProfile::setNonceValidityTime()
     * @uses XPhoneSecurityProfile::setTransportType()
     * @uses XPhoneSecurityProfile::setSipPhonePort()
     * @uses XPhoneSecurityProfile::setEnableDigestAuthentication()
     * @uses XPhoneSecurityProfile::setExcludeDigestCredentials()
     * @param string $phoneType
     * @param string $protocol
     * @param string $name
     * @param string $description
     * @param string $deviceSecurityMode
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $tftpEncryptedConfig
     * @param string $nonceValidityTime
     * @param string $transportType
     * @param string $sipPhonePort
     * @param string $enableDigestAuthentication
     * @param string $excludeDigestCredentials
     */
    public function __construct($phoneType = null, $protocol = null, $name = null, $description = null, $deviceSecurityMode = null, $authenticationMode = 'By Null String', $keySize = '1024', $tftpEncryptedConfig = false, $nonceValidityTime = '600', $transportType = 'TCP+UDP', $sipPhonePort = '5060', $enableDigestAuthentication = false, $excludeDigestCredentials = false)
    {
        $this
            ->setPhoneType($phoneType)
            ->setProtocol($protocol)
            ->setName($name)
            ->setDescription($description)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setTftpEncryptedConfig($tftpEncryptedConfig)
            ->setNonceValidityTime($nonceValidityTime)
            ->setTransportType($transportType)
            ->setSipPhonePort($sipPhonePort)
            ->setEnableDigestAuthentication($enableDigestAuthentication)
            ->setExcludeDigestCredentials($excludeDigestCredentials);
    }
    /**
     * Get phoneType value
     * @return string
     */
    public function getPhoneType()
    {
        return $this->phoneType;
    }
    /**
     * Set phoneType value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneType
     * @return XPhoneSecurityProfile
     */
    public function setPhoneType($phoneType = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($phoneType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneType, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->phoneType = $phoneType;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return XPhoneSecurityProfile
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XPhoneSecurityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return XPhoneSecurityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return isset($this->deviceSecurityMode) ? $this->deviceSecurityMode : null;
    }
    /**
     * Set deviceSecurityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XDeviceSecurityMode::valueIsValid()
     * @uses XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSecurityMode
     * @return XPhoneSecurityProfile
     */
    public function setDeviceSecurityMode($deviceSecurityMode = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceSecurityMode::valueIsValid($deviceSecurityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceSecurityMode, implode(', ', XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        if (is_null($deviceSecurityMode) || (is_array($deviceSecurityMode) && empty($deviceSecurityMode))) {
            unset($this->deviceSecurityMode);
        } else {
            $this->deviceSecurityMode = $deviceSecurityMode;
        }
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses XAuthenticationMode::valueIsValid()
     * @uses XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return XPhoneSecurityProfile
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses XKeySize::valueIsValid()
     * @uses XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return XPhoneSecurityProfile
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get tftpEncryptedConfig value
     * @return string|null
     */
    public function getTftpEncryptedConfig()
    {
        return $this->tftpEncryptedConfig;
    }
    /**
     * Set tftpEncryptedConfig value
     * @param string $tftpEncryptedConfig
     * @return XPhoneSecurityProfile
     */
    public function setTftpEncryptedConfig($tftpEncryptedConfig = false)
    {
        // validation for constraint: pattern
        if (is_scalar($tftpEncryptedConfig) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $tftpEncryptedConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($tftpEncryptedConfig, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tftpEncryptedConfig) && !is_string($tftpEncryptedConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tftpEncryptedConfig)), __LINE__);
        }
        $this->tftpEncryptedConfig = $tftpEncryptedConfig;
        return $this;
    }
    /**
     * Get nonceValidityTime value
     * @return string|null
     */
    public function getNonceValidityTime()
    {
        return $this->nonceValidityTime;
    }
    /**
     * Set nonceValidityTime value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nonceValidityTime
     * @return XPhoneSecurityProfile
     */
    public function setNonceValidityTime($nonceValidityTime = '600')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($nonceValidityTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nonceValidityTime, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->nonceValidityTime = $nonceValidityTime;
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses XTransport::valueIsValid()
     * @uses XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return XPhoneSecurityProfile
     */
    public function setTransportType($transportType = 'TCP+UDP')
    {
        // validation for constraint: enumeration
        if (!XTransport::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transportType, implode(', ', XTransport::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get sipPhonePort value
     * @return string|null
     */
    public function getSipPhonePort()
    {
        return $this->sipPhonePort;
    }
    /**
     * Set sipPhonePort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPhonePort
     * @return XPhoneSecurityProfile
     */
    public function setSipPhonePort($sipPhonePort = '5060')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($sipPhonePort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipPhonePort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->sipPhonePort = $sipPhonePort;
        return $this;
    }
    /**
     * Get enableDigestAuthentication value
     * @return string|null
     */
    public function getEnableDigestAuthentication()
    {
        return $this->enableDigestAuthentication;
    }
    /**
     * Set enableDigestAuthentication value
     * @param string $enableDigestAuthentication
     * @return XPhoneSecurityProfile
     */
    public function setEnableDigestAuthentication($enableDigestAuthentication = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableDigestAuthentication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableDigestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableDigestAuthentication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableDigestAuthentication) && !is_string($enableDigestAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableDigestAuthentication)), __LINE__);
        }
        $this->enableDigestAuthentication = $enableDigestAuthentication;
        return $this;
    }
    /**
     * Get excludeDigestCredentials value
     * @return string|null
     */
    public function getExcludeDigestCredentials()
    {
        return $this->excludeDigestCredentials;
    }
    /**
     * Set excludeDigestCredentials value
     * @param string $excludeDigestCredentials
     * @return XPhoneSecurityProfile
     */
    public function setExcludeDigestCredentials($excludeDigestCredentials = false)
    {
        // validation for constraint: pattern
        if (is_scalar($excludeDigestCredentials) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $excludeDigestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($excludeDigestCredentials, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($excludeDigestCredentials) && !is_string($excludeDigestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($excludeDigestCredentials)), __LINE__);
        }
        $this->excludeDigestCredentials = $excludeDigestCredentials;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XPhoneSecurityProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
