<?php
/**
 * This class stands for XOutboundCallRollover EnumType
 * @subpackage Enumerations
 */
class XOutboundCallRollover
{
    /**
     * Constant for value 'No Rollover'
     * @return string 'No Rollover'
     */
    const VALUE_NO_ROLLOVER = 'No Rollover';
    /**
     * Constant for value 'Rollover Within Same DN'
     * @return string 'Rollover Within Same DN'
     */
    const VALUE_ROLLOVER_WITHIN_SAME_DN = 'Rollover Within Same DN';
    /**
     * Constant for value 'Rollover to any line'
     * @return string 'Rollover to any line'
     */
    const VALUE_ROLLOVER_TO_ANY_LINE = 'Rollover to any line';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_ROLLOVER
     * @uses self::VALUE_ROLLOVER_WITHIN_SAME_DN
     * @uses self::VALUE_ROLLOVER_TO_ANY_LINE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_ROLLOVER,
            self::VALUE_ROLLOVER_WITHIN_SAME_DN,
            self::VALUE_ROLLOVER_TO_ANY_LINE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
