<?php
/**
 * This class stands for XOpsRestrict EnumType
 * @subpackage Enumerations
 */
class XOpsRestrict
{
    /**
     * Constant for value 'Do Not Use'
     * @return string 'Do Not Use'
     */
    const VALUE_DO_NOT_USE = 'Do Not Use';
    /**
     * Constant for value 'Unrestricted'
     * @return string 'Unrestricted'
     */
    const VALUE_UNRESTRICTED = 'Unrestricted';
    /**
     * Constant for value 'Read Only'
     * @return string 'Read Only'
     */
    const VALUE_READ_ONLY = 'Read Only';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DO_NOT_USE
     * @uses self::VALUE_UNRESTRICTED
     * @uses self::VALUE_READ_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DO_NOT_USE,
            self::VALUE_UNRESTRICTED,
            self::VALUE_READ_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
