<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XNumplanIdentifier StructType
 * @subpackage Structs
 */
class XNumplanIdentifier extends AbstractStructBase
{
    /**
     * The directoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 255
     * @var string
     */
    public $directoryNumber;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $routePartitionName;
    /**
     * Constructor method for XNumplanIdentifier
     * @uses XNumplanIdentifier::setDirectoryNumber()
     * @uses XNumplanIdentifier::setRoutePartitionName()
     * @param string $directoryNumber
     * @param string $routePartitionName
     */
    public function __construct($directoryNumber = null, $routePartitionName = null)
    {
        $this
            ->setDirectoryNumber($directoryNumber)
            ->setRoutePartitionName($routePartitionName);
    }
    /**
     * Get directoryNumber value
     * @return string
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param string $directoryNumber
     * @return XNumplanIdentifier
     */
    public function setDirectoryNumber($directoryNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($directoryNumber) && strlen($directoryNumber) > 255) || (is_array($directoryNumber) && count($directoryNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($directoryNumber) ? strlen($directoryNumber) : count($directoryNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directoryNumber) && !is_string($directoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryNumber)), __LINE__);
        }
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return string
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param string $routePartitionName
     * @return XNumplanIdentifier
     */
    public function setRoutePartitionName($routePartitionName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($routePartitionName) && strlen($routePartitionName) > 50) || (is_array($routePartitionName) && count($routePartitionName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($routePartitionName) ? strlen($routePartitionName) : count($routePartitionName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routePartitionName) && !is_string($routePartitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePartitionName)), __LINE__);
        }
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XNumplanIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
