<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMtp StructType
 * @subpackage Structs
 */
class XMtp extends AbstractStructBase
{
    /**
     * The mtpType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $mtpType;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The trustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trustedRelayPoint;
    /**
     * Constructor method for XMtp
     * @uses XMtp::setMtpType()
     * @uses XMtp::setName()
     * @uses XMtp::setDevicePoolName()
     * @uses XMtp::setDescription()
     * @uses XMtp::setTrustedRelayPoint()
     * @param string $mtpType
     * @param string $name
     * @param XFkType $devicePoolName
     * @param string $description
     * @param string $trustedRelayPoint
     */
    public function __construct($mtpType = null, $name = null, XFkType $devicePoolName = null, $description = null, $trustedRelayPoint = null)
    {
        $this
            ->setMtpType($mtpType)
            ->setName($name)
            ->setDevicePoolName($devicePoolName)
            ->setDescription($description)
            ->setTrustedRelayPoint($trustedRelayPoint);
    }
    /**
     * Get mtpType value
     * @return string
     */
    public function getMtpType()
    {
        return $this->mtpType;
    }
    /**
     * Set mtpType value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpType
     * @return XMtp
     */
    public function setMtpType($mtpType = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($mtpType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mtpType, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->mtpType = $mtpType;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XMtp
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return XMtp
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XMtp
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get trustedRelayPoint value
     * @return string|null
     */
    public function getTrustedRelayPoint()
    {
        return $this->trustedRelayPoint;
    }
    /**
     * Set trustedRelayPoint value
     * @param string $trustedRelayPoint
     * @return XMtp
     */
    public function setTrustedRelayPoint($trustedRelayPoint = null)
    {
        // validation for constraint: pattern
        if (is_scalar($trustedRelayPoint) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $trustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($trustedRelayPoint, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($trustedRelayPoint) && !is_string($trustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trustedRelayPoint)), __LINE__);
        }
        $this->trustedRelayPoint = $trustedRelayPoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XMtp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
