<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMohAudioSource StructType
 * @subpackage Structs
 */
class XMohAudioSource extends AbstractStructBase
{
    /**
     * The sourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $sourceId;
    /**
     * The multicast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The initialAnnouncement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $initialAnnouncement;
    /**
     * The periodicAnnouncementInterval
     * Meta informations extracted from the WSDL
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $periodicAnnouncementInterval;
    /**
     * The localeAnnouncement
     * Meta informations extracted from the WSDL
     * - default: English United States
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $localeAnnouncement;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The sourceFile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $sourceFile;
    /**
     * The repeat
     * Meta informations extracted from the WSDL
     * - documentation: This tag has been deprecated in 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeat;
    /**
     * The mohFileStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mohFileStatus;
    /**
     * The periodicAnnouncement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $periodicAnnouncement;
    /**
     * The initialAnnouncementPlayed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $initialAnnouncementPlayed;
    /**
     * Constructor method for XMohAudioSource
     * @uses XMohAudioSource::setSourceId()
     * @uses XMohAudioSource::setMulticast()
     * @uses XMohAudioSource::setInitialAnnouncement()
     * @uses XMohAudioSource::setPeriodicAnnouncementInterval()
     * @uses XMohAudioSource::setLocaleAnnouncement()
     * @uses XMohAudioSource::setName()
     * @uses XMohAudioSource::setSourceFile()
     * @uses XMohAudioSource::setRepeat()
     * @uses XMohAudioSource::setMohFileStatus()
     * @uses XMohAudioSource::setPeriodicAnnouncement()
     * @uses XMohAudioSource::setInitialAnnouncementPlayed()
     * @param string $sourceId
     * @param string $multicast
     * @param XFkType $initialAnnouncement
     * @param string $periodicAnnouncementInterval
     * @param string $localeAnnouncement
     * @param string $name
     * @param string $sourceFile
     * @param string $repeat
     * @param string $mohFileStatus
     * @param XFkType $periodicAnnouncement
     * @param string $initialAnnouncementPlayed
     */
    public function __construct($sourceId = null, $multicast = null, XFkType $initialAnnouncement = null, $periodicAnnouncementInterval = '30', $localeAnnouncement = 'English United States', $name = null, $sourceFile = null, $repeat = null, $mohFileStatus = null, XFkType $periodicAnnouncement = null, $initialAnnouncementPlayed = null)
    {
        $this
            ->setSourceId($sourceId)
            ->setMulticast($multicast)
            ->setInitialAnnouncement($initialAnnouncement)
            ->setPeriodicAnnouncementInterval($periodicAnnouncementInterval)
            ->setLocaleAnnouncement($localeAnnouncement)
            ->setName($name)
            ->setSourceFile($sourceFile)
            ->setRepeat($repeat)
            ->setMohFileStatus($mohFileStatus)
            ->setPeriodicAnnouncement($periodicAnnouncement)
            ->setInitialAnnouncementPlayed($initialAnnouncementPlayed);
    }
    /**
     * Get sourceId value
     * @return string
     */
    public function getSourceId()
    {
        return $this->sourceId;
    }
    /**
     * Set sourceId value
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceId
     * @return XMohAudioSource
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceId, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->sourceId = $sourceId;
        return $this;
    }
    /**
     * Get multicast value
     * @return string
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return XMohAudioSource
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: pattern
        if (is_scalar($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($multicast, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multicast)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get initialAnnouncement value
     * @return XFkType
     */
    public function getInitialAnnouncement()
    {
        return $this->initialAnnouncement;
    }
    /**
     * Set initialAnnouncement value
     * @param XFkType $initialAnnouncement
     * @return XMohAudioSource
     */
    public function setInitialAnnouncement(XFkType $initialAnnouncement = null)
    {
        $this->initialAnnouncement = $initialAnnouncement;
        return $this;
    }
    /**
     * Get periodicAnnouncementInterval value
     * @return string
     */
    public function getPeriodicAnnouncementInterval()
    {
        return $this->periodicAnnouncementInterval;
    }
    /**
     * Set periodicAnnouncementInterval value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicAnnouncementInterval
     * @return XMohAudioSource
     */
    public function setPeriodicAnnouncementInterval($periodicAnnouncementInterval = '30')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($periodicAnnouncementInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $periodicAnnouncementInterval, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->periodicAnnouncementInterval = $periodicAnnouncementInterval;
        return $this;
    }
    /**
     * Get localeAnnouncement value
     * @return string
     */
    public function getLocaleAnnouncement()
    {
        return $this->localeAnnouncement;
    }
    /**
     * Set localeAnnouncement value
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $localeAnnouncement
     * @return XMohAudioSource
     */
    public function setLocaleAnnouncement($localeAnnouncement = 'English United States')
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($localeAnnouncement)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $localeAnnouncement, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        $this->localeAnnouncement = $localeAnnouncement;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XMohAudioSource
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get sourceFile value
     * @return string|null
     */
    public function getSourceFile()
    {
        return $this->sourceFile;
    }
    /**
     * Set sourceFile value
     * @param string $sourceFile
     * @return XMohAudioSource
     */
    public function setSourceFile($sourceFile = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sourceFile) && strlen($sourceFile) > 255) || (is_array($sourceFile) && count($sourceFile) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($sourceFile) ? strlen($sourceFile) : count($sourceFile)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sourceFile) && !is_string($sourceFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceFile)), __LINE__);
        }
        $this->sourceFile = $sourceFile;
        return $this;
    }
    /**
     * Get repeat value
     * @return string|null
     */
    public function getRepeat()
    {
        return $this->repeat;
    }
    /**
     * Set repeat value
     * @param string $repeat
     * @return XMohAudioSource
     */
    public function setRepeat($repeat = null)
    {
        // validation for constraint: pattern
        if (is_scalar($repeat) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $repeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($repeat, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($repeat) && !is_string($repeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repeat)), __LINE__);
        }
        $this->repeat = $repeat;
        return $this;
    }
    /**
     * Get mohFileStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMohFileStatus()
    {
        return isset($this->mohFileStatus) ? $this->mohFileStatus : null;
    }
    /**
     * Set mohFileStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mohFileStatus
     * @return XMohAudioSource
     */
    public function setMohFileStatus($mohFileStatus = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($mohFileStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mohFileStatus, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($mohFileStatus) || (is_array($mohFileStatus) && empty($mohFileStatus))) {
            unset($this->mohFileStatus);
        } else {
            $this->mohFileStatus = $mohFileStatus;
        }
        return $this;
    }
    /**
     * Get periodicAnnouncement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getPeriodicAnnouncement()
    {
        return isset($this->periodicAnnouncement) ? $this->periodicAnnouncement : null;
    }
    /**
     * Set periodicAnnouncement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $periodicAnnouncement
     * @return XMohAudioSource
     */
    public function setPeriodicAnnouncement(XFkType $periodicAnnouncement = null)
    {
        if (is_null($periodicAnnouncement) || (is_array($periodicAnnouncement) && empty($periodicAnnouncement))) {
            unset($this->periodicAnnouncement);
        } else {
            $this->periodicAnnouncement = $periodicAnnouncement;
        }
        return $this;
    }
    /**
     * Get initialAnnouncementPlayed value
     * @return string|null
     */
    public function getInitialAnnouncementPlayed()
    {
        return $this->initialAnnouncementPlayed;
    }
    /**
     * Set initialAnnouncementPlayed value
     * @param string $initialAnnouncementPlayed
     * @return XMohAudioSource
     */
    public function setInitialAnnouncementPlayed($initialAnnouncementPlayed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($initialAnnouncementPlayed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($initialAnnouncementPlayed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($initialAnnouncementPlayed) && !is_string($initialAnnouncementPlayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($initialAnnouncementPlayed)), __LINE__);
        }
        $this->initialAnnouncementPlayed = $initialAnnouncementPlayed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XMohAudioSource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
