<?php
/**
 * This class stands for XMaintStatus EnumType
 * @subpackage Enumerations
 */
class XMaintStatus
{
    /**
     * Constant for value 'Offline Out of Service'
     * @return string 'Offline Out of Service'
     */
    const VALUE_OFFLINE_OUT_OF_SERVICE = 'Offline Out of Service';
    /**
     * Constant for value 'Active Primary Peer'
     * @return string 'Active Primary Peer'
     */
    const VALUE_ACTIVE_PRIMARY_PEER = 'Active Primary Peer';
    /**
     * Constant for value 'Active Standby'
     * @return string 'Active Standby'
     */
    const VALUE_ACTIVE_STANDBY = 'Active Standby';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OFFLINE_OUT_OF_SERVICE
     * @uses self::VALUE_ACTIVE_PRIMARY_PEER
     * @uses self::VALUE_ACTIVE_STANDBY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OFFLINE_OUT_OF_SERVICE,
            self::VALUE_ACTIVE_PRIMARY_PEER,
            self::VALUE_ACTIVE_STANDBY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
