<?php
/**
 * This class stands for XMOHCodec EnumType
 * @subpackage Enumerations
 */
class XMOHCodec
{
    /**
     * Constant for value '711 ulaw'
     * @return string '711 ulaw'
     */
    const VALUE_711_ULAW = '711 ulaw';
    /**
     * Constant for value '711 alaw'
     * @return string '711 alaw'
     */
    const VALUE_711_ALAW = '711 alaw';
    /**
     * Constant for value '729'
     * @return string '729'
     */
    const VALUE_729 = '729';
    /**
     * Constant for value 'wideband'
     * @return string 'wideband'
     */
    const VALUE_WIDEBAND = 'wideband';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_711_ULAW
     * @uses self::VALUE_711_ALAW
     * @uses self::VALUE_729
     * @uses self::VALUE_WIDEBAND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_711_ULAW,
            self::VALUE_711_ALAW,
            self::VALUE_729,
            self::VALUE_WIDEBAND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
