<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLicenseCapabilities StructType
 * @subpackage Structs
 */
class XLicenseCapabilities extends AbstractStructBase
{
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The enableUps
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: The only valid values for enableUPS are true, True, false and False.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableUps;
    /**
     * The enableUpc
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: The only valid values for enableUPC are true, True, false and False.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableUpc;
    /**
     * Constructor method for XLicenseCapabilities
     * @uses XLicenseCapabilities::setUserid()
     * @uses XLicenseCapabilities::setEnableUps()
     * @uses XLicenseCapabilities::setEnableUpc()
     * @param string $userid
     * @param string $enableUps
     * @param string $enableUpc
     */
    public function __construct($userid = null, $enableUps = false, $enableUpc = false)
    {
        $this
            ->setUserid($userid)
            ->setEnableUps($enableUps)
            ->setEnableUpc($enableUpc);
    }
    /**
     * Get userid value
     * @return string
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return XLicenseCapabilities
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get enableUps value
     * @return string|null
     */
    public function getEnableUps()
    {
        return $this->enableUps;
    }
    /**
     * Set enableUps value
     * @param string $enableUps
     * @return XLicenseCapabilities
     */
    public function setEnableUps($enableUps = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableUps) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableUps, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableUps) && !is_string($enableUps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableUps)), __LINE__);
        }
        $this->enableUps = $enableUps;
        return $this;
    }
    /**
     * Get enableUpc value
     * @return string|null
     */
    public function getEnableUpc()
    {
        return $this->enableUpc;
    }
    /**
     * Set enableUpc value
     * @param string $enableUpc
     * @return XLicenseCapabilities
     */
    public function setEnableUpc($enableUpc = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableUpc) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableUpc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableUpc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableUpc) && !is_string($enableUpc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableUpc)), __LINE__);
        }
        $this->enableUpc = $enableUpc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XLicenseCapabilities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
