<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLdapDirectory StructType
 * @subpackage Structs
 */
class XLdapDirectory extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The ldapDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $ldapDn;
    /**
     * The ldapPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $ldapPassword;
    /**
     * The userSearchBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $userSearchBase;
    /**
     * The intervalValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $intervalValue;
    /**
     * The nextExecTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 32
     * @var string
     */
    public $nextExecTime;
    /**
     * The servers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var Servers
     */
    public $servers;
    /**
     * The repeatable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The scheduleUnit
     * Meta informations extracted from the WSDL
     * - default: DAY
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scheduleUnit;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $middleName;
    /**
     * The phoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $phoneNumber;
    /**
     * The mailId
     * Meta informations extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mailId;
    /**
     * The ldapFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $ldapFilter;
    /**
     * The directoryUri
     * Meta informations extracted from the WSDL
     * - documentation: valid only for Active Directory
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $directoryUri;
    /**
     * Constructor method for XLdapDirectory
     * @uses XLdapDirectory::setName()
     * @uses XLdapDirectory::setLdapDn()
     * @uses XLdapDirectory::setLdapPassword()
     * @uses XLdapDirectory::setUserSearchBase()
     * @uses XLdapDirectory::setIntervalValue()
     * @uses XLdapDirectory::setNextExecTime()
     * @uses XLdapDirectory::setServers()
     * @uses XLdapDirectory::setRepeatable()
     * @uses XLdapDirectory::setScheduleUnit()
     * @uses XLdapDirectory::setMiddleName()
     * @uses XLdapDirectory::setPhoneNumber()
     * @uses XLdapDirectory::setMailId()
     * @uses XLdapDirectory::setLdapFilter()
     * @uses XLdapDirectory::setDirectoryUri()
     * @param string $name
     * @param string $ldapDn
     * @param string $ldapPassword
     * @param string $userSearchBase
     * @param string $intervalValue
     * @param string $nextExecTime
     * @param Servers $servers
     * @param string $repeatable
     * @param string $scheduleUnit
     * @param string $middleName
     * @param string $phoneNumber
     * @param string $mailId
     * @param XFkType $ldapFilter
     * @param string $directoryUri
     */
    public function __construct($name = null, $ldapDn = null, $ldapPassword = null, $userSearchBase = null, $intervalValue = null, $nextExecTime = null, Servers $servers = null, $repeatable = null, $scheduleUnit = 'DAY', $middleName = null, $phoneNumber = null, $mailId = null, XFkType $ldapFilter = null, $directoryUri = null)
    {
        $this
            ->setName($name)
            ->setLdapDn($ldapDn)
            ->setLdapPassword($ldapPassword)
            ->setUserSearchBase($userSearchBase)
            ->setIntervalValue($intervalValue)
            ->setNextExecTime($nextExecTime)
            ->setServers($servers)
            ->setRepeatable($repeatable)
            ->setScheduleUnit($scheduleUnit)
            ->setMiddleName($middleName)
            ->setPhoneNumber($phoneNumber)
            ->setMailId($mailId)
            ->setLdapFilter($ldapFilter)
            ->setDirectoryUri($directoryUri);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XLdapDirectory
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return XLdapDirectory
     */
    public function setLdapDn($ldapDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapDn) && strlen($ldapDn) > 128) || (is_array($ldapDn) && count($ldapDn) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapDn) ? strlen($ldapDn) : count($ldapDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapDn) && !is_string($ldapDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapDn)), __LINE__);
        }
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get ldapPassword value
     * @return string
     */
    public function getLdapPassword()
    {
        return $this->ldapPassword;
    }
    /**
     * Set ldapPassword value
     * @param string $ldapPassword
     * @return XLdapDirectory
     */
    public function setLdapPassword($ldapPassword = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ldapPassword) && strlen($ldapPassword) > 128) || (is_array($ldapPassword) && count($ldapPassword) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($ldapPassword) ? strlen($ldapPassword) : count($ldapPassword)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ldapPassword) && !is_string($ldapPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ldapPassword)), __LINE__);
        }
        $this->ldapPassword = $ldapPassword;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return XLdapDirectory
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userSearchBase) && strlen($userSearchBase) > 255) || (is_array($userSearchBase) && count($userSearchBase) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($userSearchBase) ? strlen($userSearchBase) : count($userSearchBase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userSearchBase) && !is_string($userSearchBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userSearchBase)), __LINE__);
        }
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get intervalValue value
     * @return string
     */
    public function getIntervalValue()
    {
        return $this->intervalValue;
    }
    /**
     * Set intervalValue value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intervalValue
     * @return XLdapDirectory
     */
    public function setIntervalValue($intervalValue = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($intervalValue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $intervalValue, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->intervalValue = $intervalValue;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return XLdapDirectory
     */
    public function setNextExecTime($nextExecTime = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nextExecTime) && strlen($nextExecTime) > 32) || (is_array($nextExecTime) && count($nextExecTime) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($nextExecTime) ? strlen($nextExecTime) : count($nextExecTime)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nextExecTime) && !is_string($nextExecTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextExecTime)), __LINE__);
        }
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get servers value
     * @return Servers
     */
    public function getServers()
    {
        return $this->servers;
    }
    /**
     * Set servers value
     * @param Servers $servers
     * @return XLdapDirectory
     */
    public function setServers(Servers $servers = null)
    {
        $this->servers = $servers;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return XLdapDirectory
     */
    public function setRepeatable($repeatable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($repeatable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($repeatable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($repeatable) && !is_string($repeatable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($repeatable)), __LINE__);
        }
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @uses XScheduleUnit::valueIsValid()
     * @uses XScheduleUnit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleUnit
     * @return XLdapDirectory
     */
    public function setScheduleUnit($scheduleUnit = 'DAY')
    {
        // validation for constraint: enumeration
        if (!XScheduleUnit::valueIsValid($scheduleUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduleUnit, implode(', ', XScheduleUnit::getValidValues())), __LINE__);
        }
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return XLdapDirectory
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($middleName) && strlen($middleName) > 128) || (is_array($middleName) && count($middleName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($middleName) ? strlen($middleName) : count($middleName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get phoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }
    /**
     * Set phoneNumber value
     * @param string $phoneNumber
     * @return XLdapDirectory
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phoneNumber) && strlen($phoneNumber) > 128) || (is_array($phoneNumber) && count($phoneNumber) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($phoneNumber) ? strlen($phoneNumber) : count($phoneNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->phoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get mailId value
     * @return string|null
     */
    public function getMailId()
    {
        return $this->mailId;
    }
    /**
     * Set mailId value
     * @param string $mailId
     * @return XLdapDirectory
     */
    public function setMailId($mailId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mailId) && strlen($mailId) > 128) || (is_array($mailId) && count($mailId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mailId) ? strlen($mailId) : count($mailId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailId) && !is_string($mailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailId)), __LINE__);
        }
        $this->mailId = $mailId;
        return $this;
    }
    /**
     * Get ldapFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getLdapFilter()
    {
        return isset($this->ldapFilter) ? $this->ldapFilter : null;
    }
    /**
     * Set ldapFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $ldapFilter
     * @return XLdapDirectory
     */
    public function setLdapFilter(XFkType $ldapFilter = null)
    {
        if (is_null($ldapFilter) || (is_array($ldapFilter) && empty($ldapFilter))) {
            unset($this->ldapFilter);
        } else {
            $this->ldapFilter = $ldapFilter;
        }
        return $this;
    }
    /**
     * Get directoryUri value
     * @return string|null
     */
    public function getDirectoryUri()
    {
        return $this->directoryUri;
    }
    /**
     * Set directoryUri value
     * @param string $directoryUri
     * @return XLdapDirectory
     */
    public function setDirectoryUri($directoryUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($directoryUri) && strlen($directoryUri) > 128) || (is_array($directoryUri) && count($directoryUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($directoryUri) ? strlen($directoryUri) : count($directoryUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directoryUri) && !is_string($directoryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryUri)), __LINE__);
        }
        $this->directoryUri = $directoryUri;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XLdapDirectory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
