<?php
/**
 * This class stands for XIPAddressingModePrefControl EnumType
 * @subpackage Enumerations
 */
class XIPAddressingModePrefControl
{
    /**
     * Constant for value 'IPv4'
     * @return string 'IPv4'
     */
    const VALUE_IPV_4 = 'IPv4';
    /**
     * Constant for value 'IPv6'
     * @return string 'IPv6'
     */
    const VALUE_IPV_6 = 'IPv6';
    /**
     * Constant for value 'Use System Default'
     * @return string 'Use System Default'
     */
    const VALUE_USE_SYSTEM_DEFAULT = 'Use System Default';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IPV_4
     * @uses self::VALUE_IPV_6
     * @uses self::VALUE_USE_SYSTEM_DEFAULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IPV_4,
            self::VALUE_IPV_6,
            self::VALUE_USE_SYSTEM_DEFAULT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
