<?php
/**
 * This class stands for XGeoLocationDevice EnumType
 * @subpackage Enumerations
 */
class XGeoLocationDevice
{
    /**
     * Constant for value 'Border'
     * @return string 'Border'
     */
    const VALUE_BORDER = 'Border';
    /**
     * Constant for value 'Interior'
     * @return string 'Interior'
     */
    const VALUE_INTERIOR = 'Interior';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BORDER
     * @uses self::VALUE_INTERIOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BORDER,
            self::VALUE_INTERIOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
