<?php
/**
 * This class stands for XGatewayUsage EnumType
 * @subpackage Enumerations
 */
class XGatewayUsage
{
    /**
     * Constant for value 'All Gateways'
     * @return string 'All Gateways'
     */
    const VALUE_ALL_GATEWAYS = 'All Gateways';
    /**
     * Constant for value 'Local Gateways Only'
     * @return string 'Local Gateways Only'
     */
    const VALUE_LOCAL_GATEWAYS_ONLY = 'Local Gateways Only';
    /**
     * Constant for value 'Custom'
     * @return string 'Custom'
     */
    const VALUE_CUSTOM = 'Custom';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL_GATEWAYS
     * @uses self::VALUE_LOCAL_GATEWAYS_ONLY
     * @uses self::VALUE_CUSTOM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL_GATEWAYS,
            self::VALUE_LOCAL_GATEWAYS_ONLY,
            self::VALUE_CUSTOM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
