<?php
/**
 * This class stands for XEvtDistMethod EnumType
 * @subpackage Enumerations
 */
class XEvtDistMethod
{
    /**
     * Constant for value 'Single Server Round Robin'
     * @return string 'Single Server Round Robin'
     */
    const VALUE_SINGLE_SERVER_ROUND_ROBIN = 'Single Server Round Robin';
    /**
     * Constant for value 'Primary Fail Over Secondary'
     * @return string 'Primary Fail Over Secondary'
     */
    const VALUE_PRIMARY_FAIL_OVER_SECONDARY = 'Primary Fail Over Secondary';
    /**
     * Constant for value 'Load Share Write Primary'
     * @return string 'Load Share Write Primary'
     */
    const VALUE_LOAD_SHARE_WRITE_PRIMARY = 'Load Share Write Primary';
    /**
     * Constant for value 'Load Share Write Anywhere'
     * @return string 'Load Share Write Anywhere'
     */
    const VALUE_LOAD_SHARE_WRITE_ANYWHERE = 'Load Share Write Anywhere';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SINGLE_SERVER_ROUND_ROBIN
     * @uses self::VALUE_PRIMARY_FAIL_OVER_SECONDARY
     * @uses self::VALUE_LOAD_SHARE_WRITE_PRIMARY
     * @uses self::VALUE_LOAD_SHARE_WRITE_ANYWHERE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SINGLE_SERVER_ROUND_ROBIN,
            self::VALUE_PRIMARY_FAIL_OVER_SECONDARY,
            self::VALUE_LOAD_SHARE_WRITE_PRIMARY,
            self::VALUE_LOAD_SHARE_WRITE_ANYWHERE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
