<?php
/**
 * This class stands for XE911LocationState EnumType
 * @subpackage Enumerations
 */
class XE911LocationState
{
    /**
     * Constant for value 'No Location Information'
     * @return string 'No Location Information'
     */
    const VALUE_NO_LOCATION_INFORMATION = 'No Location Information';
    /**
     * Constant for value 'Off Premise Location Needed'
     * @return string 'Off Premise Location Needed'
     */
    const VALUE_OFF_PREMISE_LOCATION_NEEDED = 'Off Premise Location Needed';
    /**
     * Constant for value 'Off Premise Declined'
     * @return string 'Off Premise Declined'
     */
    const VALUE_OFF_PREMISE_DECLINED = 'Off Premise Declined';
    /**
     * Constant for value 'On Premise Location Not Needed'
     * @return string 'On Premise Location Not Needed'
     */
    const VALUE_ON_PREMISE_LOCATION_NOT_NEEDED = 'On Premise Location Not Needed';
    /**
     * Constant for value 'Off Premise Have Location'
     * @return string 'Off Premise Have Location'
     */
    const VALUE_OFF_PREMISE_HAVE_LOCATION = 'Off Premise Have Location';
    /**
     * Constant for value 'Off Premise Location Update Failed'
     * @return string 'Off Premise Location Update Failed'
     */
    const VALUE_OFF_PREMISE_LOCATION_UPDATE_FAILED = 'Off Premise Location Update Failed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_LOCATION_INFORMATION
     * @uses self::VALUE_OFF_PREMISE_LOCATION_NEEDED
     * @uses self::VALUE_OFF_PREMISE_DECLINED
     * @uses self::VALUE_ON_PREMISE_LOCATION_NOT_NEEDED
     * @uses self::VALUE_OFF_PREMISE_HAVE_LOCATION
     * @uses self::VALUE_OFF_PREMISE_LOCATION_UPDATE_FAILED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_LOCATION_INFORMATION,
            self::VALUE_OFF_PREMISE_LOCATION_NEEDED,
            self::VALUE_OFF_PREMISE_DECLINED,
            self::VALUE_ON_PREMISE_LOCATION_NOT_NEEDED,
            self::VALUE_OFF_PREMISE_HAVE_LOCATION,
            self::VALUE_OFF_PREMISE_LOCATION_UPDATE_FAILED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
