<?php
/**
 * This class stands for XDeviceSecurityMode EnumType
 * @subpackage Enumerations
 */
class XDeviceSecurityMode
{
    /**
     * Constant for value 'Non Secure'
     * @return string 'Non Secure'
     */
    const VALUE_NON_SECURE = 'Non Secure';
    /**
     * Constant for value 'Authenticated'
     * @return string 'Authenticated'
     */
    const VALUE_AUTHENTICATED = 'Authenticated';
    /**
     * Constant for value 'Encrypted'
     * @return string 'Encrypted'
     */
    const VALUE_ENCRYPTED = 'Encrypted';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NON_SECURE
     * @uses self::VALUE_AUTHENTICATED
     * @uses self::VALUE_ENCRYPTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NON_SECURE,
            self::VALUE_AUTHENTICATED,
            self::VALUE_ENCRYPTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
