<?php
/**
 * This class stands for XDPProduct EnumType
 * @subpackage Enumerations
 */
class XDPProduct
{
    /**
     * Constant for value 'Cisco Unified Communications Manager'
     * @return string 'Cisco Unified Communications Manager'
     */
    const VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER = 'Cisco Unified Communications Manager';
    /**
     * Constant for value 'Cisco Unified Communications Manager Business Edition'
     * @return string 'Cisco Unified Communications Manager Business Edition'
     */
    const VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER_BUSINESS_EDITION = 'Cisco Unified Communications Manager Business Edition';
    /**
     * Constant for value 'Cisco Unified Customer Voice Portal'
     * @return string 'Cisco Unified Customer Voice Portal'
     */
    const VALUE_CISCO_UNIFIED_CUSTOMER_VOICE_PORTAL = 'Cisco Unified Customer Voice Portal';
    /**
     * Constant for value 'Cisco Unified Intelligent Contact Management Enterprise'
     * @return string 'Cisco Unified Intelligent Contact Management Enterprise'
     */
    const VALUE_CISCO_UNIFIED_INTELLIGENT_CONTACT_MANAGEMENT_ENTERPRISE = 'Cisco Unified Intelligent Contact Management Enterprise';
    /**
     * Constant for value 'Cisco Unified Contact Center Express'
     * @return string 'Cisco Unified Contact Center Express'
     */
    const VALUE_CISCO_UNIFIED_CONTACT_CENTER_EXPRESS = 'Cisco Unified Contact Center Express';
    /**
     * Constant for value 'IOS Gateway Devices'
     * @return string 'IOS Gateway Devices'
     */
    const VALUE_IOS_GATEWAY_DEVICES = 'IOS Gateway Devices';
    /**
     * Constant for value 'Cisco Unified Expert Advisor'
     * @return string 'Cisco Unified Expert Advisor'
     */
    const VALUE_CISCO_UNIFIED_EXPERT_ADVISOR = 'Cisco Unified Expert Advisor';
    /**
     * Constant for value 'Cisco Unity Connection'
     * @return string 'Cisco Unity Connection'
     */
    const VALUE_CISCO_UNITY_CONNECTION = 'Cisco Unity Connection';
    /**
     * Constant for value 'Cisco Unified Presence'
     * @return string 'Cisco Unified Presence'
     */
    const VALUE_CISCO_UNIFIED_PRESENCE = 'Cisco Unified Presence';
    /**
     * Constant for value 'Cisco Unified Contact Center Enterprise'
     * @return string 'Cisco Unified Contact Center Enterprise'
     */
    const VALUE_CISCO_UNIFIED_CONTACT_CENTER_ENTERPRISE = 'Cisco Unified Contact Center Enterprise';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER
     * @uses self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER_BUSINESS_EDITION
     * @uses self::VALUE_CISCO_UNIFIED_CUSTOMER_VOICE_PORTAL
     * @uses self::VALUE_CISCO_UNIFIED_INTELLIGENT_CONTACT_MANAGEMENT_ENTERPRISE
     * @uses self::VALUE_CISCO_UNIFIED_CONTACT_CENTER_EXPRESS
     * @uses self::VALUE_IOS_GATEWAY_DEVICES
     * @uses self::VALUE_CISCO_UNIFIED_EXPERT_ADVISOR
     * @uses self::VALUE_CISCO_UNITY_CONNECTION
     * @uses self::VALUE_CISCO_UNIFIED_PRESENCE
     * @uses self::VALUE_CISCO_UNIFIED_CONTACT_CENTER_ENTERPRISE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER,
            self::VALUE_CISCO_UNIFIED_COMMUNICATIONS_MANAGER_BUSINESS_EDITION,
            self::VALUE_CISCO_UNIFIED_CUSTOMER_VOICE_PORTAL,
            self::VALUE_CISCO_UNIFIED_INTELLIGENT_CONTACT_MANAGEMENT_ENTERPRISE,
            self::VALUE_CISCO_UNIFIED_CONTACT_CENTER_EXPRESS,
            self::VALUE_IOS_GATEWAY_DEVICES,
            self::VALUE_CISCO_UNIFIED_EXPERT_ADVISOR,
            self::VALUE_CISCO_UNITY_CONNECTION,
            self::VALUE_CISCO_UNIFIED_PRESENCE,
            self::VALUE_CISCO_UNIFIED_CONTACT_CENTER_ENTERPRISE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
