<?php
/**
 * This class stands for XDPDeviceProtocol EnumType
 * @subpackage Enumerations
 */
class XDPDeviceProtocol
{
    /**
     * Constant for value 'telnet'
     * @return string 'telnet'
     */
    const VALUE_TELNET = 'telnet';
    /**
     * Constant for value 'ssh'
     * @return string 'ssh'
     */
    const VALUE_SSH = 'ssh';
    /**
     * Constant for value 'https'
     * @return string 'https'
     */
    const VALUE_HTTPS = 'https';
    /**
     * Constant for value 'ftp'
     * @return string 'ftp'
     */
    const VALUE_FTP = 'ftp';
    /**
     * Constant for value 'sftp'
     * @return string 'sftp'
     */
    const VALUE_SFTP = 'sftp';
    /**
     * Constant for value 'smtp'
     * @return string 'smtp'
     */
    const VALUE_SMTP = 'smtp';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TELNET
     * @uses self::VALUE_SSH
     * @uses self::VALUE_HTTPS
     * @uses self::VALUE_FTP
     * @uses self::VALUE_SFTP
     * @uses self::VALUE_SMTP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TELNET,
            self::VALUE_SSH,
            self::VALUE_HTTPS,
            self::VALUE_FTP,
            self::VALUE_SFTP,
            self::VALUE_SMTP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
