<?php
/**
 * This class stands for XDNUsage EnumType
 * @subpackage Enumerations
 */
class XDNUsage
{
    /**
     * Constant for value 'Undefined'
     * @return string 'Undefined'
     */
    const VALUE_UNDEFINED = 'Undefined';
    /**
     * Constant for value 'Primary'
     * @return string 'Primary'
     */
    const VALUE_PRIMARY = 'Primary';
    /**
     * Constant for value 'ICD'
     * @return string 'ICD'
     */
    const VALUE_ICD = 'ICD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_PRIMARY
     * @uses self::VALUE_ICD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNDEFINED,
            self::VALUE_PRIMARY,
            self::VALUE_ICD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
