<?php
/**
 * This class stands for XCubaProductDisplayGroup EnumType
 * @subpackage Enumerations
 */
class XCubaProductDisplayGroup
{
    /**
     * Constant for value 'Analog Phones'
     * @return string 'Analog Phones'
     */
    const VALUE_ANALOG_PHONES = 'Analog Phones';
    /**
     * Constant for value 'Hardware IP Phones'
     * @return string 'Hardware IP Phones'
     */
    const VALUE_HARDWARE_IP_PHONES = 'Hardware IP Phones';
    /**
     * Constant for value 'Software IP Phones'
     * @return string 'Software IP Phones'
     */
    const VALUE_SOFTWARE_IP_PHONES = 'Software IP Phones';
    /**
     * Constant for value 'Dual Mode Phones'
     * @return string 'Dual Mode Phones'
     */
    const VALUE_DUAL_MODE_PHONES = 'Dual Mode Phones';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANALOG_PHONES
     * @uses self::VALUE_HARDWARE_IP_PHONES
     * @uses self::VALUE_SOFTWARE_IP_PHONES
     * @uses self::VALUE_DUAL_MODE_PHONES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANALOG_PHONES,
            self::VALUE_HARDWARE_IP_PHONES,
            self::VALUE_SOFTWARE_IP_PHONES,
            self::VALUE_DUAL_MODE_PHONES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
