<?php
/**
 * This class stands for XCertificateStatus EnumType
 * @subpackage Enumerations
 */
class XCertificateStatus
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Operation Pending'
     * @return string 'Operation Pending'
     */
    const VALUE_OPERATION_PENDING = 'Operation Pending';
    /**
     * Constant for value 'Upgrade Success'
     * @return string 'Upgrade Success'
     */
    const VALUE_UPGRADE_SUCCESS = 'Upgrade Success';
    /**
     * Constant for value 'Delete Success'
     * @return string 'Delete Success'
     */
    const VALUE_DELETE_SUCCESS = 'Delete Success';
    /**
     * Constant for value 'Troubleshoot Success'
     * @return string 'Troubleshoot Success'
     */
    const VALUE_TROUBLESHOOT_SUCCESS = 'Troubleshoot Success';
    /**
     * Constant for value 'Upgrade Failed'
     * @return string 'Upgrade Failed'
     */
    const VALUE_UPGRADE_FAILED = 'Upgrade Failed';
    /**
     * Constant for value 'Delete Failed'
     * @return string 'Delete Failed'
     */
    const VALUE_DELETE_FAILED = 'Delete Failed';
    /**
     * Constant for value 'Troubleshoot Failed'
     * @return string 'Troubleshoot Failed'
     */
    const VALUE_TROUBLESHOOT_FAILED = 'Troubleshoot Failed';
    /**
     * Constant for value 'Upgrade Failed: Invalid LSC'
     * @return string 'Upgrade Failed: Invalid LSC'
     */
    const VALUE_UPGRADE_FAILED_INVALID_LSC = 'Upgrade Failed: Invalid LSC';
    /**
     * Constant for value 'Upgrade Failed: Invalid Authentication String'
     * @return string 'Upgrade Failed: Invalid Authentication String'
     */
    const VALUE_UPGRADE_FAILED_INVALID_AUTHENTICATION_STRING = 'Upgrade Failed: Invalid Authentication String';
    /**
     * Constant for value 'Upgrade Failed: Invalid MIC'
     * @return string 'Upgrade Failed: Invalid MIC'
     */
    const VALUE_UPGRADE_FAILED_INVALID_MIC = 'Upgrade Failed: Invalid MIC';
    /**
     * Constant for value 'Upgrade Failed: Invalid Credentials'
     * @return string 'Upgrade Failed: Invalid Credentials'
     */
    const VALUE_UPGRADE_FAILED_INVALID_CREDENTIALS = 'Upgrade Failed: Invalid Credentials';
    /**
     * Constant for value 'Upgrade Failed: Phone Communication Failure'
     * @return string 'Upgrade Failed: Phone Communication Failure'
     */
    const VALUE_UPGRADE_FAILED_PHONE_COMMUNICATION_FAILURE = 'Upgrade Failed: Phone Communication Failure';
    /**
     * Constant for value 'Upgrade Failed: Key Generation Failed/Timeout'
     * @return string 'Upgrade Failed: Key Generation Failed/Timeout'
     */
    const VALUE_UPGRADE_FAILED_KEY_GENERATION_FAILED_TIMEOUT = 'Upgrade Failed: Key Generation Failed/Timeout';
    /**
     * Constant for value 'Upgrade Failed: CA Communication Failure'
     * @return string 'Upgrade Failed: CA Communication Failure'
     */
    const VALUE_UPGRADE_FAILED_CA_COMMUNICATION_FAILURE = 'Upgrade Failed: CA Communication Failure';
    /**
     * Constant for value 'Upgrade Failed: CA Rejected Connection'
     * @return string 'Upgrade Failed: CA Rejected Connection'
     */
    const VALUE_UPGRADE_FAILED_CA_REJECTED_CONNECTION = 'Upgrade Failed: CA Rejected Connection';
    /**
     * Constant for value 'Upgrade Failed: User Initiated Request Late/Timedout'
     * @return string 'Upgrade Failed: User Initiated Request Late/Timedout'
     */
    const VALUE_UPGRADE_FAILED_USER_INITIATED_REQUEST_LATE_TIMEDOUT = 'Upgrade Failed: User Initiated Request Late/Timedout';
    /**
     * Constant for value 'Delete Failed: Invalid LSC'
     * @return string 'Delete Failed: Invalid LSC'
     */
    const VALUE_DELETE_FAILED_INVALID_LSC = 'Delete Failed: Invalid LSC';
    /**
     * Constant for value 'Delete Failed: Invalid Authentication String'
     * @return string 'Delete Failed: Invalid Authentication String'
     */
    const VALUE_DELETE_FAILED_INVALID_AUTHENTICATION_STRING = 'Delete Failed: Invalid Authentication String';
    /**
     * Constant for value 'Delete Failed: Invalid MIC'
     * @return string 'Delete Failed: Invalid MIC'
     */
    const VALUE_DELETE_FAILED_INVALID_MIC = 'Delete Failed: Invalid MIC';
    /**
     * Constant for value 'Delete Failed: Invalid Credentials'
     * @return string 'Delete Failed: Invalid Credentials'
     */
    const VALUE_DELETE_FAILED_INVALID_CREDENTIALS = 'Delete Failed: Invalid Credentials';
    /**
     * Constant for value 'Delete Failed: Phone Communication Failure'
     * @return string 'Delete Failed: Phone Communication Failure'
     */
    const VALUE_DELETE_FAILED_PHONE_COMMUNICATION_FAILURE = 'Delete Failed: Phone Communication Failure';
    /**
     * Constant for value 'Delete Failed: Key Generation Failed/Timeout'
     * @return string 'Delete Failed: Key Generation Failed/Timeout'
     */
    const VALUE_DELETE_FAILED_KEY_GENERATION_FAILED_TIMEOUT = 'Delete Failed: Key Generation Failed/Timeout';
    /**
     * Constant for value 'Delete Failed: CA Communication Failure'
     * @return string 'Delete Failed: CA Communication Failure'
     */
    const VALUE_DELETE_FAILED_CA_COMMUNICATION_FAILURE = 'Delete Failed: CA Communication Failure';
    /**
     * Constant for value 'Delete Failed: CA Rejected Connection'
     * @return string 'Delete Failed: CA Rejected Connection'
     */
    const VALUE_DELETE_FAILED_CA_REJECTED_CONNECTION = 'Delete Failed: CA Rejected Connection';
    /**
     * Constant for value 'Delete Failed: User Initiated Request Late/Timedout'
     * @return string 'Delete Failed: User Initiated Request Late/Timedout'
     */
    const VALUE_DELETE_FAILED_USER_INITIATED_REQUEST_LATE_TIMEDOUT = 'Delete Failed: User Initiated Request Late/Timedout';
    /**
     * Constant for value 'Troubleshoot Failed: Invalid LSC'
     * @return string 'Troubleshoot Failed: Invalid LSC'
     */
    const VALUE_TROUBLESHOOT_FAILED_INVALID_LSC = 'Troubleshoot Failed: Invalid LSC';
    /**
     * Constant for value 'Troubleshoot Failed: Invalid Authentication String'
     * @return string 'Troubleshoot Failed: Invalid Authentication String'
     */
    const VALUE_TROUBLESHOOT_FAILED_INVALID_AUTHENTICATION_STRING = 'Troubleshoot Failed: Invalid Authentication String';
    /**
     * Constant for value 'Troubleshoot Failed: Invalid MIC'
     * @return string 'Troubleshoot Failed: Invalid MIC'
     */
    const VALUE_TROUBLESHOOT_FAILED_INVALID_MIC = 'Troubleshoot Failed: Invalid MIC';
    /**
     * Constant for value 'Troubleshoot Failed: Invalid Credentials'
     * @return string 'Troubleshoot Failed: Invalid Credentials'
     */
    const VALUE_TROUBLESHOOT_FAILED_INVALID_CREDENTIALS = 'Troubleshoot Failed: Invalid Credentials';
    /**
     * Constant for value 'Troubleshoot Failed: Phone Communication Failure'
     * @return string 'Troubleshoot Failed: Phone Communication Failure'
     */
    const VALUE_TROUBLESHOOT_FAILED_PHONE_COMMUNICATION_FAILURE = 'Troubleshoot Failed: Phone Communication Failure';
    /**
     * Constant for value 'Troubleshoot Failed: Key Generation Failed/Timeout'
     * @return string 'Troubleshoot Failed: Key Generation Failed/Timeout'
     */
    const VALUE_TROUBLESHOOT_FAILED_KEY_GENERATION_FAILED_TIMEOUT = 'Troubleshoot Failed: Key Generation Failed/Timeout';
    /**
     * Constant for value 'Troubleshoot Failed: User Initiated Request Late/Timedout'
     * @return string 'Troubleshoot Failed: User Initiated Request Late/Timedout'
     */
    const VALUE_TROUBLESHOOT_FAILED_USER_INITIATED_REQUEST_LATE_TIMEDOUT = 'Troubleshoot Failed: User Initiated Request Late/Timedout';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_OPERATION_PENDING
     * @uses self::VALUE_UPGRADE_SUCCESS
     * @uses self::VALUE_DELETE_SUCCESS
     * @uses self::VALUE_TROUBLESHOOT_SUCCESS
     * @uses self::VALUE_UPGRADE_FAILED
     * @uses self::VALUE_DELETE_FAILED
     * @uses self::VALUE_TROUBLESHOOT_FAILED
     * @uses self::VALUE_UPGRADE_FAILED_INVALID_LSC
     * @uses self::VALUE_UPGRADE_FAILED_INVALID_AUTHENTICATION_STRING
     * @uses self::VALUE_UPGRADE_FAILED_INVALID_MIC
     * @uses self::VALUE_UPGRADE_FAILED_INVALID_CREDENTIALS
     * @uses self::VALUE_UPGRADE_FAILED_PHONE_COMMUNICATION_FAILURE
     * @uses self::VALUE_UPGRADE_FAILED_KEY_GENERATION_FAILED_TIMEOUT
     * @uses self::VALUE_UPGRADE_FAILED_CA_COMMUNICATION_FAILURE
     * @uses self::VALUE_UPGRADE_FAILED_CA_REJECTED_CONNECTION
     * @uses self::VALUE_UPGRADE_FAILED_USER_INITIATED_REQUEST_LATE_TIMEDOUT
     * @uses self::VALUE_DELETE_FAILED_INVALID_LSC
     * @uses self::VALUE_DELETE_FAILED_INVALID_AUTHENTICATION_STRING
     * @uses self::VALUE_DELETE_FAILED_INVALID_MIC
     * @uses self::VALUE_DELETE_FAILED_INVALID_CREDENTIALS
     * @uses self::VALUE_DELETE_FAILED_PHONE_COMMUNICATION_FAILURE
     * @uses self::VALUE_DELETE_FAILED_KEY_GENERATION_FAILED_TIMEOUT
     * @uses self::VALUE_DELETE_FAILED_CA_COMMUNICATION_FAILURE
     * @uses self::VALUE_DELETE_FAILED_CA_REJECTED_CONNECTION
     * @uses self::VALUE_DELETE_FAILED_USER_INITIATED_REQUEST_LATE_TIMEDOUT
     * @uses self::VALUE_TROUBLESHOOT_FAILED_INVALID_LSC
     * @uses self::VALUE_TROUBLESHOOT_FAILED_INVALID_AUTHENTICATION_STRING
     * @uses self::VALUE_TROUBLESHOOT_FAILED_INVALID_MIC
     * @uses self::VALUE_TROUBLESHOOT_FAILED_INVALID_CREDENTIALS
     * @uses self::VALUE_TROUBLESHOOT_FAILED_PHONE_COMMUNICATION_FAILURE
     * @uses self::VALUE_TROUBLESHOOT_FAILED_KEY_GENERATION_FAILED_TIMEOUT
     * @uses self::VALUE_TROUBLESHOOT_FAILED_USER_INITIATED_REQUEST_LATE_TIMEDOUT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_OPERATION_PENDING,
            self::VALUE_UPGRADE_SUCCESS,
            self::VALUE_DELETE_SUCCESS,
            self::VALUE_TROUBLESHOOT_SUCCESS,
            self::VALUE_UPGRADE_FAILED,
            self::VALUE_DELETE_FAILED,
            self::VALUE_TROUBLESHOOT_FAILED,
            self::VALUE_UPGRADE_FAILED_INVALID_LSC,
            self::VALUE_UPGRADE_FAILED_INVALID_AUTHENTICATION_STRING,
            self::VALUE_UPGRADE_FAILED_INVALID_MIC,
            self::VALUE_UPGRADE_FAILED_INVALID_CREDENTIALS,
            self::VALUE_UPGRADE_FAILED_PHONE_COMMUNICATION_FAILURE,
            self::VALUE_UPGRADE_FAILED_KEY_GENERATION_FAILED_TIMEOUT,
            self::VALUE_UPGRADE_FAILED_CA_COMMUNICATION_FAILURE,
            self::VALUE_UPGRADE_FAILED_CA_REJECTED_CONNECTION,
            self::VALUE_UPGRADE_FAILED_USER_INITIATED_REQUEST_LATE_TIMEDOUT,
            self::VALUE_DELETE_FAILED_INVALID_LSC,
            self::VALUE_DELETE_FAILED_INVALID_AUTHENTICATION_STRING,
            self::VALUE_DELETE_FAILED_INVALID_MIC,
            self::VALUE_DELETE_FAILED_INVALID_CREDENTIALS,
            self::VALUE_DELETE_FAILED_PHONE_COMMUNICATION_FAILURE,
            self::VALUE_DELETE_FAILED_KEY_GENERATION_FAILED_TIMEOUT,
            self::VALUE_DELETE_FAILED_CA_COMMUNICATION_FAILURE,
            self::VALUE_DELETE_FAILED_CA_REJECTED_CONNECTION,
            self::VALUE_DELETE_FAILED_USER_INITIATED_REQUEST_LATE_TIMEDOUT,
            self::VALUE_TROUBLESHOOT_FAILED_INVALID_LSC,
            self::VALUE_TROUBLESHOOT_FAILED_INVALID_AUTHENTICATION_STRING,
            self::VALUE_TROUBLESHOOT_FAILED_INVALID_MIC,
            self::VALUE_TROUBLESHOOT_FAILED_INVALID_CREDENTIALS,
            self::VALUE_TROUBLESHOOT_FAILED_PHONE_COMMUNICATION_FAILURE,
            self::VALUE_TROUBLESHOOT_FAILED_KEY_GENERATION_FAILED_TIMEOUT,
            self::VALUE_TROUBLESHOOT_FAILED_USER_INITIATED_REQUEST_LATE_TIMEDOUT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
