<?php
/**
 * This class stands for XCertificateOperation EnumType
 * @subpackage Enumerations
 */
class XCertificateOperation
{
    /**
     * Constant for value 'No Pending Operation'
     * @return string 'No Pending Operation'
     */
    const VALUE_NO_PENDING_OPERATION = 'No Pending Operation';
    /**
     * Constant for value 'Install/Upgrade'
     * @return string 'Install/Upgrade'
     */
    const VALUE_INSTALL_UPGRADE = 'Install/Upgrade';
    /**
     * Constant for value 'Delete'
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Constant for value 'Troubleshoot'
     * @return string 'Troubleshoot'
     */
    const VALUE_TROUBLESHOOT = 'Troubleshoot';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_PENDING_OPERATION
     * @uses self::VALUE_INSTALL_UPGRADE
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_TROUBLESHOOT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_PENDING_OPERATION,
            self::VALUE_INSTALL_UPGRADE,
            self::VALUE_DELETE,
            self::VALUE_TROUBLESHOOT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
