<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCalledPartyTransformationPattern StructType
 * @subpackage Structs
 */
class XCalledPartyTransformationPattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The calledPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routeFilterName;
    /**
     * The calledPartyPrefixDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyPrefixDigits;
    /**
     * The calledPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * Constructor method for XCalledPartyTransformationPattern
     * @uses XCalledPartyTransformationPattern::setPattern()
     * @uses XCalledPartyTransformationPattern::setRoutePartitionName()
     * @uses XCalledPartyTransformationPattern::setDescription()
     * @uses XCalledPartyTransformationPattern::setCalledPartyTransformationMask()
     * @uses XCalledPartyTransformationPattern::setDialPlanName()
     * @uses XCalledPartyTransformationPattern::setDigitDiscardInstructionName()
     * @uses XCalledPartyTransformationPattern::setRouteFilterName()
     * @uses XCalledPartyTransformationPattern::setCalledPartyPrefixDigits()
     * @uses XCalledPartyTransformationPattern::setCalledPartyNumberingPlan()
     * @uses XCalledPartyTransformationPattern::setCalledPartyNumberType()
     * @param string $pattern
     * @param XFkType $routePartitionName
     * @param string $description
     * @param string $calledPartyTransformationMask
     * @param XFkType $dialPlanName
     * @param XFkType $digitDiscardInstructionName
     * @param XFkType $routeFilterName
     * @param string $calledPartyPrefixDigits
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     */
    public function __construct($pattern = null, XFkType $routePartitionName = null, $description = null, $calledPartyTransformationMask = null, XFkType $dialPlanName = null, XFkType $digitDiscardInstructionName = null, XFkType $routeFilterName = null, $calledPartyPrefixDigits = null, $calledPartyNumberingPlan = 'Cisco CallManager', $calledPartyNumberType = 'Cisco CallManager')
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setDescription($description)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setRouteFilterName($routeFilterName)
            ->setCalledPartyPrefixDigits($calledPartyPrefixDigits)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return XCalledPartyTransformationPattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return XCalledPartyTransformationPattern
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XCalledPartyTransformationPattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return isset($this->calledPartyTransformationMask) ? $this->calledPartyTransformationMask : null;
    }
    /**
     * Set calledPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyTransformationMask
     * @return XCalledPartyTransformationPattern
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyTransformationMask)), __LINE__);
        }
        if (is_null($calledPartyTransformationMask) || (is_array($calledPartyTransformationMask) && empty($calledPartyTransformationMask))) {
            unset($this->calledPartyTransformationMask);
        } else {
            $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get dialPlanName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDialPlanName()
    {
        return isset($this->dialPlanName) ? $this->dialPlanName : null;
    }
    /**
     * Set dialPlanName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $dialPlanName
     * @return XCalledPartyTransformationPattern
     */
    public function setDialPlanName(XFkType $dialPlanName = null)
    {
        if (is_null($dialPlanName) || (is_array($dialPlanName) && empty($dialPlanName))) {
            unset($this->dialPlanName);
        } else {
            $this->dialPlanName = $dialPlanName;
        }
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return isset($this->digitDiscardInstructionName) ? $this->digitDiscardInstructionName : null;
    }
    /**
     * Set digitDiscardInstructionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $digitDiscardInstructionName
     * @return XCalledPartyTransformationPattern
     */
    public function setDigitDiscardInstructionName(XFkType $digitDiscardInstructionName = null)
    {
        if (is_null($digitDiscardInstructionName) || (is_array($digitDiscardInstructionName) && empty($digitDiscardInstructionName))) {
            unset($this->digitDiscardInstructionName);
        } else {
            $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        }
        return $this;
    }
    /**
     * Get routeFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRouteFilterName()
    {
        return isset($this->routeFilterName) ? $this->routeFilterName : null;
    }
    /**
     * Set routeFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $routeFilterName
     * @return XCalledPartyTransformationPattern
     */
    public function setRouteFilterName(XFkType $routeFilterName = null)
    {
        if (is_null($routeFilterName) || (is_array($routeFilterName) && empty($routeFilterName))) {
            unset($this->routeFilterName);
        } else {
            $this->routeFilterName = $routeFilterName;
        }
        return $this;
    }
    /**
     * Get calledPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyPrefixDigits()
    {
        return isset($this->calledPartyPrefixDigits) ? $this->calledPartyPrefixDigits : null;
    }
    /**
     * Set calledPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyPrefixDigits
     * @return XCalledPartyTransformationPattern
     */
    public function setCalledPartyPrefixDigits($calledPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyPrefixDigits) && !is_string($calledPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyPrefixDigits)), __LINE__);
        }
        if (is_null($calledPartyPrefixDigits) || (is_array($calledPartyPrefixDigits) && empty($calledPartyPrefixDigits))) {
            unset($this->calledPartyPrefixDigits);
        } else {
            $this->calledPartyPrefixDigits = $calledPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return XCalledPartyTransformationPattern
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberingPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return XCalledPartyTransformationPattern
     */
    public function setCalledPartyNumberType($calledPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberType, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XCalledPartyTransformationPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
