<?php
/**
 * This class stands for XApplyToCall EnumType
 * @subpackage Enumerations
 */
class XApplyToCall
{
    /**
     * Constant for value 'Never'
     * @return string 'Never'
     */
    const VALUE_NEVER = 'Never';
    /**
     * Constant for value 'Always'
     * @return string 'Always'
     */
    const VALUE_ALWAYS = 'Always';
    /**
     * Constant for value 'Per Call'
     * @return string 'Per Call'
     */
    const VALUE_PER_CALL = 'Per Call';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEVER
     * @uses self::VALUE_ALWAYS
     * @uses self::VALUE_PER_CALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEVER,
            self::VALUE_ALWAYS,
            self::VALUE_PER_CALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
