<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XApplicationToSoftKeyTemplate StructType
 * @subpackage Structs
 */
class XApplicationToSoftKeyTemplate extends AbstractStructBase
{
    /**
     * The softKeyTemplateName
     * Meta informations extracted from the WSDL
     * - documentation: This template should not be a standard template
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $softKeyTemplateName;
    /**
     * The standardSoftKeyTemplateName
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $standardSoftKeyTemplateName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for XApplicationToSoftKeyTemplate
     * @uses XApplicationToSoftKeyTemplate::setSoftKeyTemplateName()
     * @uses XApplicationToSoftKeyTemplate::setStandardSoftKeyTemplateName()
     * @uses XApplicationToSoftKeyTemplate::setUuid()
     * @param XFkType $softKeyTemplateName
     * @param XFkType $standardSoftKeyTemplateName
     * @param string $uuid
     */
    public function __construct(XFkType $softKeyTemplateName = null, XFkType $standardSoftKeyTemplateName = null, $uuid = null)
    {
        $this
            ->setSoftKeyTemplateName($softKeyTemplateName)
            ->setStandardSoftKeyTemplateName($standardSoftKeyTemplateName)
            ->setUuid($uuid);
    }
    /**
     * Get softKeyTemplateName value
     * @return XFkType
     */
    public function getSoftKeyTemplateName()
    {
        return $this->softKeyTemplateName;
    }
    /**
     * Set softKeyTemplateName value
     * @param XFkType $softKeyTemplateName
     * @return XApplicationToSoftKeyTemplate
     */
    public function setSoftKeyTemplateName(XFkType $softKeyTemplateName = null)
    {
        $this->softKeyTemplateName = $softKeyTemplateName;
        return $this;
    }
    /**
     * Get standardSoftKeyTemplateName value
     * @return XFkType
     */
    public function getStandardSoftKeyTemplateName()
    {
        return $this->standardSoftKeyTemplateName;
    }
    /**
     * Set standardSoftKeyTemplateName value
     * @param XFkType $standardSoftKeyTemplateName
     * @return XApplicationToSoftKeyTemplate
     */
    public function setStandardSoftKeyTemplateName(XFkType $standardSoftKeyTemplateName = null)
    {
        $this->standardSoftKeyTemplateName = $standardSoftKeyTemplateName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return XApplicationToSoftKeyTemplate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XApplicationToSoftKeyTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
