<?php
/**
 * This class stands for XApplicationDialRule EnumType
 * @subpackage Enumerations
 */
class XApplicationDialRule
{
    /**
     * Constant for value 'Original Dial Rule'
     * @return string 'Original Dial Rule'
     */
    const VALUE_ORIGINAL_DIAL_RULE = 'Original Dial Rule';
    /**
     * Constant for value 'Directory Dial Rule'
     * @return string 'Directory Dial Rule'
     */
    const VALUE_DIRECTORY_DIAL_RULE = 'Directory Dial Rule';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORIGINAL_DIAL_RULE
     * @uses self::VALUE_DIRECTORY_DIAL_RULE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORIGINAL_DIAL_RULE,
            self::VALUE_DIRECTORY_DIAL_RULE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
