<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAnnunciator StructType
 * @subpackage Structs
 */
class XAnnunciator extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $locationName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * Constructor method for XAnnunciator
     * @uses XAnnunciator::setName()
     * @uses XAnnunciator::setDevicePoolName()
     * @uses XAnnunciator::setLocationName()
     * @uses XAnnunciator::setDescription()
     * @uses XAnnunciator::setUseTrustedRelayPoint()
     * @param string $name
     * @param XFkType $devicePoolName
     * @param XFkType $locationName
     * @param string $description
     * @param string $useTrustedRelayPoint
     */
    public function __construct($name = null, XFkType $devicePoolName = null, XFkType $locationName = null, $description = null, $useTrustedRelayPoint = 'Default')
    {
        $this
            ->setName($name)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setDescription($description)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XAnnunciator
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return XAnnunciator
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return XAnnunciator
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XAnnunciator
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return XAnnunciator
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XAnnunciator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
