<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePhoneButtonTemplateReq StructType
 * @subpackage Structs
 */
class UpdatePhoneButtonTemplateReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - documentation: The template's name
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The buttons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Buttons
     */
    public $buttons;
    /**
     * Constructor method for UpdatePhoneButtonTemplateReq
     * @uses UpdatePhoneButtonTemplateReq::setNewName()
     * @uses UpdatePhoneButtonTemplateReq::setButtons()
     * @param string $newName
     * @param Buttons $buttons
     */
    public function __construct($newName = null, Buttons $buttons = null)
    {
        $this
            ->setNewName($newName)
            ->setButtons($buttons);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdatePhoneButtonTemplateReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get buttons value
     * @return Buttons|null
     */
    public function getButtons()
    {
        return $this->buttons;
    }
    /**
     * Set buttons value
     * @param Buttons $buttons
     * @return UpdatePhoneButtonTemplateReq
     */
    public function setButtons(Buttons $buttons = null)
    {
        $this->buttons = $buttons;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdatePhoneButtonTemplateReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
