<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDevicePoolReq StructType
 * @subpackage Structs
 */
class UpdateDevicePoolReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - documentation: Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The autoSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $autoSearchSpaceName;
    /**
     * The dateTimeSettingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $dateTimeSettingName;
    /**
     * The callManagerGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $callManagerGroupName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mediaResourceListName;
    /**
     * The regionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $regionName;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - documentation: Nullable. The value accepted and retrieved from the database for this field will be of type XCountry in AXLEnums.xsd
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The srstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var XFkType
     */
    public $srstName;
    /**
     * The connectionMonitorDuration
     * Meta informations extracted from the WSDL
     * - default: -1
     * - documentation: -1 means using system default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectionMonitorDuration;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - documentation: The calling search space used by Automated Alternate Routing. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - documentation: For IP Phones and Gateways. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $locationName;
    /**
     * The mobilityCssName
     * Meta informations extracted from the WSDL
     * - documentation: The calling search space used by Device Mobility. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mobilityCssName;
    /**
     * The physicalLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $physicalLocationName;
    /**
     * The deviceMobilityGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $deviceMobilityGroupName;
    /**
     * The revertPriority
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: The value accepted and retrieved from the database for this field will be of type XRevertPriority in AXLEnums.xsd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $revertPriority;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The localRouteGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $localRouteGroupName;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationFilterName;
    /**
     * The callingPartyNationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $callingPartyNationalPrefix;
    /**
     * The callingPartyInternationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $callingPartyInternationalPrefix;
    /**
     * The callingPartyUnknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $callingPartyUnknownPrefix;
    /**
     * The callingPartySubscriberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $callingPartySubscriberPrefix;
    /**
     * The adjunctCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $adjunctCallingSearchSpace;
    /**
     * The callingPartyNationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyNationalStripDigits;
    /**
     * The callingPartyInternationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyInternationalStripDigits;
    /**
     * The callingPartyUnknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartyUnknownStripDigits;
    /**
     * The callingPartySubscriberStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callingPartySubscriberStripDigits;
    /**
     * The callingPartyNationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingPartyNationalTransformationCssName;
    /**
     * The callingPartyInternationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingPartyInternationalTransformationCssName;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The callingPartySubscriberTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $callingPartySubscriberTransformationCssName;
    /**
     * The calledPartyNationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The imeEnrolledPatternGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $imeEnrolledPatternGroupName;
    /**
     * The cntdPnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * Constructor method for UpdateDevicePoolReq
     * @uses UpdateDevicePoolReq::setNewName()
     * @uses UpdateDevicePoolReq::setAutoSearchSpaceName()
     * @uses UpdateDevicePoolReq::setDateTimeSettingName()
     * @uses UpdateDevicePoolReq::setCallManagerGroupName()
     * @uses UpdateDevicePoolReq::setMediaResourceListName()
     * @uses UpdateDevicePoolReq::setRegionName()
     * @uses UpdateDevicePoolReq::setNetworkLocale()
     * @uses UpdateDevicePoolReq::setSrstName()
     * @uses UpdateDevicePoolReq::setConnectionMonitorDuration()
     * @uses UpdateDevicePoolReq::setAutomatedAlternateRoutingCssName()
     * @uses UpdateDevicePoolReq::setAarNeighborhoodName()
     * @uses UpdateDevicePoolReq::setLocationName()
     * @uses UpdateDevicePoolReq::setMobilityCssName()
     * @uses UpdateDevicePoolReq::setPhysicalLocationName()
     * @uses UpdateDevicePoolReq::setDeviceMobilityGroupName()
     * @uses UpdateDevicePoolReq::setRevertPriority()
     * @uses UpdateDevicePoolReq::setSingleButtonBarge()
     * @uses UpdateDevicePoolReq::setJoinAcrossLines()
     * @uses UpdateDevicePoolReq::setCgpnTransformationCssName()
     * @uses UpdateDevicePoolReq::setCdpnTransformationCssName()
     * @uses UpdateDevicePoolReq::setLocalRouteGroupName()
     * @uses UpdateDevicePoolReq::setGeoLocationName()
     * @uses UpdateDevicePoolReq::setGeoLocationFilterName()
     * @uses UpdateDevicePoolReq::setCallingPartyNationalPrefix()
     * @uses UpdateDevicePoolReq::setCallingPartyInternationalPrefix()
     * @uses UpdateDevicePoolReq::setCallingPartyUnknownPrefix()
     * @uses UpdateDevicePoolReq::setCallingPartySubscriberPrefix()
     * @uses UpdateDevicePoolReq::setAdjunctCallingSearchSpace()
     * @uses UpdateDevicePoolReq::setCallingPartyNationalStripDigits()
     * @uses UpdateDevicePoolReq::setCallingPartyInternationalStripDigits()
     * @uses UpdateDevicePoolReq::setCallingPartyUnknownStripDigits()
     * @uses UpdateDevicePoolReq::setCallingPartySubscriberStripDigits()
     * @uses UpdateDevicePoolReq::setCallingPartyNationalTransformationCssName()
     * @uses UpdateDevicePoolReq::setCallingPartyInternationalTransformationCssName()
     * @uses UpdateDevicePoolReq::setCallingPartyUnknownTransformationCssName()
     * @uses UpdateDevicePoolReq::setCallingPartySubscriberTransformationCssName()
     * @uses UpdateDevicePoolReq::setCalledPartyNationalPrefix()
     * @uses UpdateDevicePoolReq::setCalledPartyInternationalPrefix()
     * @uses UpdateDevicePoolReq::setCalledPartyUnknownPrefix()
     * @uses UpdateDevicePoolReq::setCalledPartySubscriberPrefix()
     * @uses UpdateDevicePoolReq::setCalledPartyNationalStripDigits()
     * @uses UpdateDevicePoolReq::setCalledPartyInternationalStripDigits()
     * @uses UpdateDevicePoolReq::setCalledPartyUnknownStripDigits()
     * @uses UpdateDevicePoolReq::setCalledPartySubscriberStripDigits()
     * @uses UpdateDevicePoolReq::setCalledPartyNationalTransformationCssName()
     * @uses UpdateDevicePoolReq::setCalledPartyInternationalTransformationCssName()
     * @uses UpdateDevicePoolReq::setCalledPartyUnknownTransformationCssName()
     * @uses UpdateDevicePoolReq::setCalledPartySubscriberTransformationCssName()
     * @uses UpdateDevicePoolReq::setImeEnrolledPatternGroupName()
     * @uses UpdateDevicePoolReq::setCntdPnTransformationCssName()
     * @param string $newName
     * @param XFkType $autoSearchSpaceName
     * @param XFkType $dateTimeSettingName
     * @param XFkType $callManagerGroupName
     * @param XFkType $mediaResourceListName
     * @param XFkType $regionName
     * @param string $networkLocale
     * @param XFkType $srstName
     * @param string $connectionMonitorDuration
     * @param XFkType $automatedAlternateRoutingCssName
     * @param XFkType $aarNeighborhoodName
     * @param XFkType $locationName
     * @param XFkType $mobilityCssName
     * @param XFkType $physicalLocationName
     * @param XFkType $deviceMobilityGroupName
     * @param string $revertPriority
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param XFkType $cgpnTransformationCssName
     * @param XFkType $cdpnTransformationCssName
     * @param XFkType $localRouteGroupName
     * @param XFkType $geoLocationName
     * @param XFkType $geoLocationFilterName
     * @param string $callingPartyNationalPrefix
     * @param string $callingPartyInternationalPrefix
     * @param string $callingPartyUnknownPrefix
     * @param string $callingPartySubscriberPrefix
     * @param XFkType $adjunctCallingSearchSpace
     * @param string $callingPartyNationalStripDigits
     * @param string $callingPartyInternationalStripDigits
     * @param string $callingPartyUnknownStripDigits
     * @param string $callingPartySubscriberStripDigits
     * @param XFkType $callingPartyNationalTransformationCssName
     * @param XFkType $callingPartyInternationalTransformationCssName
     * @param XFkType $callingPartyUnknownTransformationCssName
     * @param XFkType $callingPartySubscriberTransformationCssName
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param XFkType $calledPartyNationalTransformationCssName
     * @param XFkType $calledPartyInternationalTransformationCssName
     * @param XFkType $calledPartyUnknownTransformationCssName
     * @param XFkType $calledPartySubscriberTransformationCssName
     * @param XFkType $imeEnrolledPatternGroupName
     * @param XFkType $cntdPnTransformationCssName
     */
    public function __construct($newName = null, XFkType $autoSearchSpaceName = null, XFkType $dateTimeSettingName = null, XFkType $callManagerGroupName = null, XFkType $mediaResourceListName = null, XFkType $regionName = null, $networkLocale = null, XFkType $srstName = null, $connectionMonitorDuration = '-1', XFkType $automatedAlternateRoutingCssName = null, XFkType $aarNeighborhoodName = null, XFkType $locationName = null, XFkType $mobilityCssName = null, XFkType $physicalLocationName = null, XFkType $deviceMobilityGroupName = null, $revertPriority = 'Default', $singleButtonBarge = 'Default', $joinAcrossLines = 'Default', XFkType $cgpnTransformationCssName = null, XFkType $cdpnTransformationCssName = null, XFkType $localRouteGroupName = null, XFkType $geoLocationName = null, XFkType $geoLocationFilterName = null, $callingPartyNationalPrefix = null, $callingPartyInternationalPrefix = null, $callingPartyUnknownPrefix = null, $callingPartySubscriberPrefix = null, XFkType $adjunctCallingSearchSpace = null, $callingPartyNationalStripDigits = null, $callingPartyInternationalStripDigits = null, $callingPartyUnknownStripDigits = null, $callingPartySubscriberStripDigits = null, XFkType $callingPartyNationalTransformationCssName = null, XFkType $callingPartyInternationalTransformationCssName = null, XFkType $callingPartyUnknownTransformationCssName = null, XFkType $callingPartySubscriberTransformationCssName = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, XFkType $calledPartyNationalTransformationCssName = null, XFkType $calledPartyInternationalTransformationCssName = null, XFkType $calledPartyUnknownTransformationCssName = null, XFkType $calledPartySubscriberTransformationCssName = null, XFkType $imeEnrolledPatternGroupName = null, XFkType $cntdPnTransformationCssName = null)
    {
        $this
            ->setNewName($newName)
            ->setAutoSearchSpaceName($autoSearchSpaceName)
            ->setDateTimeSettingName($dateTimeSettingName)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setRegionName($regionName)
            ->setNetworkLocale($networkLocale)
            ->setSrstName($srstName)
            ->setConnectionMonitorDuration($connectionMonitorDuration)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLocationName($locationName)
            ->setMobilityCssName($mobilityCssName)
            ->setPhysicalLocationName($physicalLocationName)
            ->setDeviceMobilityGroupName($deviceMobilityGroupName)
            ->setRevertPriority($revertPriority)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setLocalRouteGroupName($localRouteGroupName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setCallingPartyNationalPrefix($callingPartyNationalPrefix)
            ->setCallingPartyInternationalPrefix($callingPartyInternationalPrefix)
            ->setCallingPartyUnknownPrefix($callingPartyUnknownPrefix)
            ->setCallingPartySubscriberPrefix($callingPartySubscriberPrefix)
            ->setAdjunctCallingSearchSpace($adjunctCallingSearchSpace)
            ->setCallingPartyNationalStripDigits($callingPartyNationalStripDigits)
            ->setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits)
            ->setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits)
            ->setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits)
            ->setCallingPartyNationalTransformationCssName($callingPartyNationalTransformationCssName)
            ->setCallingPartyInternationalTransformationCssName($callingPartyInternationalTransformationCssName)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setCallingPartySubscriberTransformationCssName($callingPartySubscriberTransformationCssName)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateDevicePoolReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get autoSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAutoSearchSpaceName()
    {
        return isset($this->autoSearchSpaceName) ? $this->autoSearchSpaceName : null;
    }
    /**
     * Set autoSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $autoSearchSpaceName
     * @return UpdateDevicePoolReq
     */
    public function setAutoSearchSpaceName(XFkType $autoSearchSpaceName = null)
    {
        if (is_null($autoSearchSpaceName) || (is_array($autoSearchSpaceName) && empty($autoSearchSpaceName))) {
            unset($this->autoSearchSpaceName);
        } else {
            $this->autoSearchSpaceName = $autoSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get dateTimeSettingName value
     * @return XFkType|null
     */
    public function getDateTimeSettingName()
    {
        return $this->dateTimeSettingName;
    }
    /**
     * Set dateTimeSettingName value
     * @param XFkType $dateTimeSettingName
     * @return UpdateDevicePoolReq
     */
    public function setDateTimeSettingName(XFkType $dateTimeSettingName = null)
    {
        $this->dateTimeSettingName = $dateTimeSettingName;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param XFkType $callManagerGroupName
     * @return UpdateDevicePoolReq
     */
    public function setCallManagerGroupName(XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mediaResourceListName
     * @return UpdateDevicePoolReq
     */
    public function setMediaResourceListName(XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get regionName value
     * @return XFkType|null
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param XFkType $regionName
     * @return UpdateDevicePoolReq
     */
    public function setRegionName(XFkType $regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XCountry::valueIsValid()
     * @uses XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return UpdateDevicePoolReq
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', XCountry::getValidValues())), __LINE__);
        }
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get srstName value
     * @return XFkType|null
     */
    public function getSrstName()
    {
        return $this->srstName;
    }
    /**
     * Set srstName value
     * @param XFkType $srstName
     * @return UpdateDevicePoolReq
     */
    public function setSrstName(XFkType $srstName = null)
    {
        $this->srstName = $srstName;
        return $this;
    }
    /**
     * Get connectionMonitorDuration value
     * @return string|null
     */
    public function getConnectionMonitorDuration()
    {
        return $this->connectionMonitorDuration;
    }
    /**
     * Set connectionMonitorDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectionMonitorDuration
     * @return UpdateDevicePoolReq
     */
    public function setConnectionMonitorDuration($connectionMonitorDuration = '-1')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($connectionMonitorDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectionMonitorDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->connectionMonitorDuration = $connectionMonitorDuration;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $automatedAlternateRoutingCssName
     * @return UpdateDevicePoolReq
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $aarNeighborhoodName
     * @return UpdateDevicePoolReq
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get locationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return isset($this->locationName) ? $this->locationName : null;
    }
    /**
     * Set locationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $locationName
     * @return UpdateDevicePoolReq
     */
    public function setLocationName(XFkType $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->locationName);
        } else {
            $this->locationName = $locationName;
        }
        return $this;
    }
    /**
     * Get mobilityCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMobilityCssName()
    {
        return isset($this->mobilityCssName) ? $this->mobilityCssName : null;
    }
    /**
     * Set mobilityCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mobilityCssName
     * @return UpdateDevicePoolReq
     */
    public function setMobilityCssName(XFkType $mobilityCssName = null)
    {
        if (is_null($mobilityCssName) || (is_array($mobilityCssName) && empty($mobilityCssName))) {
            unset($this->mobilityCssName);
        } else {
            $this->mobilityCssName = $mobilityCssName;
        }
        return $this;
    }
    /**
     * Get physicalLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getPhysicalLocationName()
    {
        return isset($this->physicalLocationName) ? $this->physicalLocationName : null;
    }
    /**
     * Set physicalLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $physicalLocationName
     * @return UpdateDevicePoolReq
     */
    public function setPhysicalLocationName(XFkType $physicalLocationName = null)
    {
        if (is_null($physicalLocationName) || (is_array($physicalLocationName) && empty($physicalLocationName))) {
            unset($this->physicalLocationName);
        } else {
            $this->physicalLocationName = $physicalLocationName;
        }
        return $this;
    }
    /**
     * Get deviceMobilityGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDeviceMobilityGroupName()
    {
        return isset($this->deviceMobilityGroupName) ? $this->deviceMobilityGroupName : null;
    }
    /**
     * Set deviceMobilityGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $deviceMobilityGroupName
     * @return UpdateDevicePoolReq
     */
    public function setDeviceMobilityGroupName(XFkType $deviceMobilityGroupName = null)
    {
        if (is_null($deviceMobilityGroupName) || (is_array($deviceMobilityGroupName) && empty($deviceMobilityGroupName))) {
            unset($this->deviceMobilityGroupName);
        } else {
            $this->deviceMobilityGroupName = $deviceMobilityGroupName;
        }
        return $this;
    }
    /**
     * Get revertPriority value
     * @return string|null
     */
    public function getRevertPriority()
    {
        return $this->revertPriority;
    }
    /**
     * Set revertPriority value
     * @uses XRevertPriority::valueIsValid()
     * @uses XRevertPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $revertPriority
     * @return UpdateDevicePoolReq
     */
    public function setRevertPriority($revertPriority = 'Default')
    {
        // validation for constraint: enumeration
        if (!XRevertPriority::valueIsValid($revertPriority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $revertPriority, implode(', ', XRevertPriority::getValidValues())), __LINE__);
        }
        $this->revertPriority = $revertPriority;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses XBarge::valueIsValid()
     * @uses XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return UpdateDevicePoolReq
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        // validation for constraint: enumeration
        if (!XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return UpdateDevicePoolReq
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cgpnTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCgpnTransformationCssName(XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cdpnTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCdpnTransformationCssName(XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get localRouteGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getLocalRouteGroupName()
    {
        return isset($this->localRouteGroupName) ? $this->localRouteGroupName : null;
    }
    /**
     * Set localRouteGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $localRouteGroupName
     * @return UpdateDevicePoolReq
     */
    public function setLocalRouteGroupName(XFkType $localRouteGroupName = null)
    {
        if (is_null($localRouteGroupName) || (is_array($localRouteGroupName) && empty($localRouteGroupName))) {
            unset($this->localRouteGroupName);
        } else {
            $this->localRouteGroupName = $localRouteGroupName;
        }
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $geoLocationName
     * @return UpdateDevicePoolReq
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $geoLocationFilterName
     * @return UpdateDevicePoolReq
     */
    public function setGeoLocationFilterName(XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalPrefix value
     * @return string|null
     */
    public function getCallingPartyNationalPrefix()
    {
        return $this->callingPartyNationalPrefix;
    }
    /**
     * Set callingPartyNationalPrefix value
     * @param string $callingPartyNationalPrefix
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartyNationalPrefix($callingPartyNationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyNationalPrefix) && strlen($callingPartyNationalPrefix) > 16) || (is_array($callingPartyNationalPrefix) && count($callingPartyNationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyNationalPrefix) ? strlen($callingPartyNationalPrefix) : count($callingPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyNationalPrefix) && !is_string($callingPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyNationalPrefix)), __LINE__);
        }
        $this->callingPartyNationalPrefix = $callingPartyNationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyInternationalPrefix value
     * @return string|null
     */
    public function getCallingPartyInternationalPrefix()
    {
        return $this->callingPartyInternationalPrefix;
    }
    /**
     * Set callingPartyInternationalPrefix value
     * @param string $callingPartyInternationalPrefix
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartyInternationalPrefix($callingPartyInternationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyInternationalPrefix) && strlen($callingPartyInternationalPrefix) > 16) || (is_array($callingPartyInternationalPrefix) && count($callingPartyInternationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyInternationalPrefix) ? strlen($callingPartyInternationalPrefix) : count($callingPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyInternationalPrefix) && !is_string($callingPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyInternationalPrefix)), __LINE__);
        }
        $this->callingPartyInternationalPrefix = $callingPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyUnknownPrefix value
     * @return string|null
     */
    public function getCallingPartyUnknownPrefix()
    {
        return $this->callingPartyUnknownPrefix;
    }
    /**
     * Set callingPartyUnknownPrefix value
     * @param string $callingPartyUnknownPrefix
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartyUnknownPrefix($callingPartyUnknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyUnknownPrefix) && strlen($callingPartyUnknownPrefix) > 16) || (is_array($callingPartyUnknownPrefix) && count($callingPartyUnknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyUnknownPrefix) ? strlen($callingPartyUnknownPrefix) : count($callingPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyUnknownPrefix) && !is_string($callingPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyUnknownPrefix)), __LINE__);
        }
        $this->callingPartyUnknownPrefix = $callingPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get callingPartySubscriberPrefix value
     * @return string|null
     */
    public function getCallingPartySubscriberPrefix()
    {
        return $this->callingPartySubscriberPrefix;
    }
    /**
     * Set callingPartySubscriberPrefix value
     * @param string $callingPartySubscriberPrefix
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartySubscriberPrefix($callingPartySubscriberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartySubscriberPrefix) && strlen($callingPartySubscriberPrefix) > 16) || (is_array($callingPartySubscriberPrefix) && count($callingPartySubscriberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartySubscriberPrefix) ? strlen($callingPartySubscriberPrefix) : count($callingPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartySubscriberPrefix) && !is_string($callingPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartySubscriberPrefix)), __LINE__);
        }
        $this->callingPartySubscriberPrefix = $callingPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get adjunctCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getAdjunctCallingSearchSpace()
    {
        return isset($this->adjunctCallingSearchSpace) ? $this->adjunctCallingSearchSpace : null;
    }
    /**
     * Set adjunctCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $adjunctCallingSearchSpace
     * @return UpdateDevicePoolReq
     */
    public function setAdjunctCallingSearchSpace(XFkType $adjunctCallingSearchSpace = null)
    {
        if (is_null($adjunctCallingSearchSpace) || (is_array($adjunctCallingSearchSpace) && empty($adjunctCallingSearchSpace))) {
            unset($this->adjunctCallingSearchSpace);
        } else {
            $this->adjunctCallingSearchSpace = $adjunctCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyNationalStripDigits()
    {
        return isset($this->callingPartyNationalStripDigits) ? $this->callingPartyNationalStripDigits : null;
    }
    /**
     * Set callingPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNationalStripDigits
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartyNationalStripDigits($callingPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($callingPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNationalStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyNationalStripDigits) || (is_array($callingPartyNationalStripDigits) && empty($callingPartyNationalStripDigits))) {
            unset($this->callingPartyNationalStripDigits);
        } else {
            $this->callingPartyNationalStripDigits = $callingPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyInternationalStripDigits()
    {
        return isset($this->callingPartyInternationalStripDigits) ? $this->callingPartyInternationalStripDigits : null;
    }
    /**
     * Set callingPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyInternationalStripDigits
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($callingPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyInternationalStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyInternationalStripDigits) || (is_array($callingPartyInternationalStripDigits) && empty($callingPartyInternationalStripDigits))) {
            unset($this->callingPartyInternationalStripDigits);
        } else {
            $this->callingPartyInternationalStripDigits = $callingPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartyUnknownStripDigits()
    {
        return isset($this->callingPartyUnknownStripDigits) ? $this->callingPartyUnknownStripDigits : null;
    }
    /**
     * Set callingPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyUnknownStripDigits
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($callingPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyUnknownStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartyUnknownStripDigits) || (is_array($callingPartyUnknownStripDigits) && empty($callingPartyUnknownStripDigits))) {
            unset($this->callingPartyUnknownStripDigits);
        } else {
            $this->callingPartyUnknownStripDigits = $callingPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallingPartySubscriberStripDigits()
    {
        return isset($this->callingPartySubscriberStripDigits) ? $this->callingPartySubscriberStripDigits : null;
    }
    /**
     * Set callingPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySubscriberStripDigits
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($callingPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySubscriberStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callingPartySubscriberStripDigits) || (is_array($callingPartySubscriberStripDigits) && empty($callingPartySubscriberStripDigits))) {
            unset($this->callingPartySubscriberStripDigits);
        } else {
            $this->callingPartySubscriberStripDigits = $callingPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get callingPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingPartyNationalTransformationCssName()
    {
        return isset($this->callingPartyNationalTransformationCssName) ? $this->callingPartyNationalTransformationCssName : null;
    }
    /**
     * Set callingPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingPartyNationalTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartyNationalTransformationCssName(XFkType $callingPartyNationalTransformationCssName = null)
    {
        if (is_null($callingPartyNationalTransformationCssName) || (is_array($callingPartyNationalTransformationCssName) && empty($callingPartyNationalTransformationCssName))) {
            unset($this->callingPartyNationalTransformationCssName);
        } else {
            $this->callingPartyNationalTransformationCssName = $callingPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingPartyInternationalTransformationCssName()
    {
        return isset($this->callingPartyInternationalTransformationCssName) ? $this->callingPartyInternationalTransformationCssName : null;
    }
    /**
     * Set callingPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingPartyInternationalTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartyInternationalTransformationCssName(XFkType $callingPartyInternationalTransformationCssName = null)
    {
        if (is_null($callingPartyInternationalTransformationCssName) || (is_array($callingPartyInternationalTransformationCssName) && empty($callingPartyInternationalTransformationCssName))) {
            unset($this->callingPartyInternationalTransformationCssName);
        } else {
            $this->callingPartyInternationalTransformationCssName = $callingPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return isset($this->callingPartyUnknownTransformationCssName) ? $this->callingPartyUnknownTransformationCssName : null;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingPartyUnknownTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartyUnknownTransformationCssName(XFkType $callingPartyUnknownTransformationCssName = null)
    {
        if (is_null($callingPartyUnknownTransformationCssName) || (is_array($callingPartyUnknownTransformationCssName) && empty($callingPartyUnknownTransformationCssName))) {
            unset($this->callingPartyUnknownTransformationCssName);
        } else {
            $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get callingPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCallingPartySubscriberTransformationCssName()
    {
        return isset($this->callingPartySubscriberTransformationCssName) ? $this->callingPartySubscriberTransformationCssName : null;
    }
    /**
     * Set callingPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $callingPartySubscriberTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCallingPartySubscriberTransformationCssName(XFkType $callingPartySubscriberTransformationCssName = null)
    {
        if (is_null($callingPartySubscriberTransformationCssName) || (is_array($callingPartySubscriberTransformationCssName) && empty($callingPartySubscriberTransformationCssName))) {
            unset($this->callingPartySubscriberTransformationCssName);
        } else {
            $this->callingPartySubscriberTransformationCssName = $callingPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyNationalPrefix) && strlen($calledPartyNationalPrefix) > 16) || (is_array($calledPartyNationalPrefix) && count($calledPartyNationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyNationalPrefix) ? strlen($calledPartyNationalPrefix) : count($calledPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyNationalPrefix) && !is_string($calledPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyNationalPrefix)), __LINE__);
        }
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyInternationalPrefix) && strlen($calledPartyInternationalPrefix) > 16) || (is_array($calledPartyInternationalPrefix) && count($calledPartyInternationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyInternationalPrefix) ? strlen($calledPartyInternationalPrefix) : count($calledPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyInternationalPrefix) && !is_string($calledPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyInternationalPrefix)), __LINE__);
        }
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyUnknownPrefix) && strlen($calledPartyUnknownPrefix) > 16) || (is_array($calledPartyUnknownPrefix) && count($calledPartyUnknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyUnknownPrefix) ? strlen($calledPartyUnknownPrefix) : count($calledPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyUnknownPrefix) && !is_string($calledPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyUnknownPrefix)), __LINE__);
        }
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartySubscriberPrefix) && strlen($calledPartySubscriberPrefix) > 16) || (is_array($calledPartySubscriberPrefix) && count($calledPartySubscriberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartySubscriberPrefix) ? strlen($calledPartySubscriberPrefix) : count($calledPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartySubscriberPrefix) && !is_string($calledPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartySubscriberPrefix)), __LINE__);
        }
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return isset($this->calledPartyNationalStripDigits) ? $this->calledPartyNationalStripDigits : null;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNationalStripDigits
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($calledPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNationalStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyNationalStripDigits) || (is_array($calledPartyNationalStripDigits) && empty($calledPartyNationalStripDigits))) {
            unset($this->calledPartyNationalStripDigits);
        } else {
            $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return isset($this->calledPartyInternationalStripDigits) ? $this->calledPartyInternationalStripDigits : null;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyInternationalStripDigits
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($calledPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyInternationalStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyInternationalStripDigits) || (is_array($calledPartyInternationalStripDigits) && empty($calledPartyInternationalStripDigits))) {
            unset($this->calledPartyInternationalStripDigits);
        } else {
            $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return isset($this->calledPartyUnknownStripDigits) ? $this->calledPartyUnknownStripDigits : null;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyUnknownStripDigits
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($calledPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyUnknownStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyUnknownStripDigits) || (is_array($calledPartyUnknownStripDigits) && empty($calledPartyUnknownStripDigits))) {
            unset($this->calledPartyUnknownStripDigits);
        } else {
            $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return isset($this->calledPartySubscriberStripDigits) ? $this->calledPartySubscriberStripDigits : null;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartySubscriberStripDigits
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($calledPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartySubscriberStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartySubscriberStripDigits) || (is_array($calledPartySubscriberStripDigits) && empty($calledPartySubscriberStripDigits))) {
            unset($this->calledPartySubscriberStripDigits);
        } else {
            $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return isset($this->calledPartyNationalTransformationCssName) ? $this->calledPartyNationalTransformationCssName : null;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $calledPartyNationalTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartyNationalTransformationCssName(XFkType $calledPartyNationalTransformationCssName = null)
    {
        if (is_null($calledPartyNationalTransformationCssName) || (is_array($calledPartyNationalTransformationCssName) && empty($calledPartyNationalTransformationCssName))) {
            unset($this->calledPartyNationalTransformationCssName);
        } else {
            $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return isset($this->calledPartyInternationalTransformationCssName) ? $this->calledPartyInternationalTransformationCssName : null;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $calledPartyInternationalTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartyInternationalTransformationCssName(XFkType $calledPartyInternationalTransformationCssName = null)
    {
        if (is_null($calledPartyInternationalTransformationCssName) || (is_array($calledPartyInternationalTransformationCssName) && empty($calledPartyInternationalTransformationCssName))) {
            unset($this->calledPartyInternationalTransformationCssName);
        } else {
            $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return isset($this->calledPartyUnknownTransformationCssName) ? $this->calledPartyUnknownTransformationCssName : null;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $calledPartyUnknownTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartyUnknownTransformationCssName(XFkType $calledPartyUnknownTransformationCssName = null)
    {
        if (is_null($calledPartyUnknownTransformationCssName) || (is_array($calledPartyUnknownTransformationCssName) && empty($calledPartyUnknownTransformationCssName))) {
            unset($this->calledPartyUnknownTransformationCssName);
        } else {
            $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return isset($this->calledPartySubscriberTransformationCssName) ? $this->calledPartySubscriberTransformationCssName : null;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $calledPartySubscriberTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCalledPartySubscriberTransformationCssName(XFkType $calledPartySubscriberTransformationCssName = null)
    {
        if (is_null($calledPartySubscriberTransformationCssName) || (is_array($calledPartySubscriberTransformationCssName) && empty($calledPartySubscriberTransformationCssName))) {
            unset($this->calledPartySubscriberTransformationCssName);
        } else {
            $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getImeEnrolledPatternGroupName()
    {
        return isset($this->imeEnrolledPatternGroupName) ? $this->imeEnrolledPatternGroupName : null;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $imeEnrolledPatternGroupName
     * @return UpdateDevicePoolReq
     */
    public function setImeEnrolledPatternGroupName(XFkType $imeEnrolledPatternGroupName = null)
    {
        if (is_null($imeEnrolledPatternGroupName) || (is_array($imeEnrolledPatternGroupName) && empty($imeEnrolledPatternGroupName))) {
            unset($this->imeEnrolledPatternGroupName);
        } else {
            $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        }
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return isset($this->cntdPnTransformationCssName) ? $this->cntdPnTransformationCssName : null;
    }
    /**
     * Set cntdPnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cntdPnTransformationCssName
     * @return UpdateDevicePoolReq
     */
    public function setCntdPnTransformationCssName(XFkType $cntdPnTransformationCssName = null)
    {
        if (is_null($cntdPnTransformationCssName) || (is_array($cntdPnTransformationCssName) && empty($cntdPnTransformationCssName))) {
            unset($this->cntdPnTransformationCssName);
        } else {
            $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateDevicePoolReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
